﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Tizen;
using Tizen.Network.WiFi;
using Xamarin.Forms;
using Xamarin.Forms.Xaml;

namespace WiFiDemo.Tizen
{
    [XamlCompilation(XamlCompilationOptions.Compile)]
    public partial class MainPage : ContentPage
    {
        IEnumerable<WiFiAP> _wifiAP = null;
        WiFiAP _device = null;
        public MainPage()
        {
            InitializeComponent();
            enable.Clicked += OnEnableClicked;
            disable.Clicked += OnDisableClicked;
            scan.Clicked += OnScanClicked;
            connect.Clicked += OnConnectClicked;
            picker.Items.Add("Scan again");
            picker.SelectedIndexChanged += OnAPSelect;
        }

        void OnAPSelect(object sender, EventArgs e)
        {
            Log.Debug("WIFITESTLOG", "onapselect, ap info");
            if (picker.SelectedIndex > 0)
            {
                if (_device != null)
                    _device.Dispose();
                _device = new WiFiAP(picker.Items[picker.SelectedIndex]);
                cell.Text = "Device " + _device.NetworkInformation.Essid + " is selected";
                Log.Debug("WIFITESTLOG", "onapselect, ap info =" + _device.NetworkInformation.Essid + ", " + _device.NetworkInformation.ConnectionState);
            }
            else
            {
                cell.Text = "Device is not selected";
            }
        }

        async void OnConnectClicked(object sender, EventArgs e)
        {
            WiFiManager.BackgroundScanFinished -= ScanFinished;
            if (!WiFiManager.IsActive)
            {
                cell.Text = "Enable Wi-Fi";
                return;
            }
            else
            {
                if (_device != null)
                {
                    cell.Text = "Connecting to " + _device.NetworkInformation.Essid;
                    WiFiManager.ConnectionStateChanged += StateChanged;
                    await _device.ConnectAsync();
                    await Task.Delay(4000);
                }
                else
                {
                    cell.Text = "Device not found cannot connect";
                    return;
                }
            }
        }

        void StateChanged(Object sender, ConnectionStateChangedEventArgs e)
        {
            Log.Debug("WIFITESTLOG", "StateChanged");
            if (e.State == WiFiConnectionState.Connected)
                cell.Text = "Device connected " + e.AP.NetworkInformation.Essid.ToString();
            if (e.State == WiFiConnectionState.Disconnected)
                cell.Text = "Deivce is not connected";
        }

        async void OnEnableClicked(Object sender, EventArgs e)
        {
            if (WiFiManager.IsActive)
            {
                cell.Text = "Wi-Fi is already enabled";
                return;
            }

            WiFiManager.ActivateAsync();
            cell.Text = "Wi-Fi is getting enabled";
            await Task.Delay(5000);
            if (WiFiManager.IsActive)
                cell.Text = "Wi-Fi is enabled";
        }
        async void OnDisableClicked(Object sender, EventArgs e)
        {
            Log.Debug("WIFITESTLOG", "ondisableclicked");
            if (!WiFiManager.IsActive)
            {
                cell.Text = "Wi-Fi is already disabled";
                return;
            }

            if (_device != null)
            {
                Log.Debug("WIFITESTLOG", "disconnectstart ");
                try
                {
                    WiFiAP _device1 = WiFiManager.GetConnectedAP();
                    await Task.Delay(6000);
                    await _device1.DisconnectAsync();
                    await Task.Delay(6000);
                    _device1.ForgetAP();

                    WiFiManager.ConnectionStateChanged -= StateChanged;
                }

                catch (Exception ex)
                {
                    Log.Debug("WIFITESTLOG", "disconnectstart " + ex.ToString());
                }
                Log.Debug("WIFITESTLOG", "disconnect end");
            }

            Log.Debug("WIFITESTLOG", "deactivatestart ");
            WiFiManager.DeactivateAsync();

            Log.Debug("WIFITESTLOG", "deactivate end ");
            cell.Text = "Wi-Fi is getting disabled";
            await Task.Delay(5000);
            if (!WiFiManager.IsActive)
                cell.Text = "Wi-Fi is disabled";
        }
        void OnScanClicked(Object sender, EventArgs e)
        {
            if (!WiFiManager.IsActive)
            {
                cell.Text = "Enable Wi-Fi";
                return;
            }

            cell.Text = "Scan is pressed";
            picker.Items.Clear();
            picker.Items.Add("Scan again");
            picker.SelectedIndex = 0;
            _wifiAP = null;

            WiFiManager.BackgroundScanFinished += ScanFinished;
            WiFiManager.ScanAsync();
            _wifiAP = WiFiManager.GetFoundAPs();

            foreach (WiFiAP ap in _wifiAP)
            {
                picker.Items.Add(ap.NetworkInformation.Essid);
            }

            //cell.Text = "Scan is finished";
        }

        void ScanFinished(Object sender, EventArgs e)
        {
            cell.Text = "Scan completed";
        }
    }
}