﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Tizen.Uix.Tts;
using Xamarin.Forms;
using Xamarin.Forms.Xaml;

namespace TTSDemo.Tizen
{
    [XamlCompilation(XamlCompilationOptions.Compile)]
    public partial class MainPage : ContentPage
    {
        private TtsClient _ttsInst = new TtsClient();

        public MainPage()
        {
            InitializeComponent();
            _ttsInst.StateChanged += _ttsInst_StateChanged;
            _ttsInst.Prepare();

            _playBtn.Clicked += (sender, e) =>
            {
                string text = _editorCell.Text;
                if (!String.IsNullOrEmpty(text))
                {
                    try
                    {
                        _ttsInst.AddText(text, "en_US", 0, 0);
                        _ttsInst.Play();
                        _editorCell.Text = "";
                        _playBtn.IsEnabled = false;
                        _stopBtn.IsEnabled = true;
                    }
                    catch (Exception ex)
                    {
                        global::Tizen.Log.Error("TTSDemo", ex.ToString());
                    }
                }
            };

            _stopBtn.Clicked += (sender, e) =>
            {
                try
                {
                    _ttsInst.Stop();
                    _stopBtn.IsEnabled = false;
                    _playBtn.IsEnabled = true;
                }
                catch (Exception ex)
                {
                    global::Tizen.Log.Error("TTSDemo", ex.ToString());
                }
            };
        }

        ~MainPage()
        {
            _ttsInst.Unprepare();
            _ttsInst.StateChanged -= _ttsInst_StateChanged;
        }

        private void _ttsInst_StateChanged(object sender, StateChangedEventArgs e)
        {
            global::Tizen.Log.Info("TTSDemo", " Previous:" + e.Previous + " Current:" + e.Current);
        }
    }
}