﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Tizen.Uix.Stt;

using Xamarin.Forms;
using Xamarin.Forms.Xaml;

namespace STTDemo.Tizen
{
    [XamlCompilation(XamlCompilationOptions.Compile)]
    public partial class MainPage : ContentPage
    {
        private SttClient _sttInst = new SttClient();
        public MainPage()
        {
            InitializeComponent();
            _sttInst.StateChanged += _sttInst_StateChanged;
            _sttInst.RecognitionResult += _sttInst_RecognitionResult;
            _sttInst.Prepare();

            _playBtn.Clicked += (sender, e) =>
            {
                try
                {
                    _label.Text = "";
                    _sttInst.Start("en_US", RecognitionType.Free);
                    _playBtn.IsEnabled = false;
                    _stopBtn.IsEnabled = true;
                }
                catch (Exception ex)
                {
                    global::Tizen.Log.Error("STTDemo", ex.ToString());
                }
            };

            _stopBtn.Clicked += (sender, e) =>
            {
                try
                {
                    _sttInst.Stop();
                    _stopBtn.IsEnabled = false;
                    _playBtn.IsEnabled = true;
                }
                catch (Exception ex)
                {
                    global::Tizen.Log.Error("STTDemo", ex.ToString());
                }
            };
        }

        private void _sttInst_RecognitionResult(object sender, RecognitionResultEventArgs e)
        {
            global::Tizen.Log.Info("STTDemo", " Result:" + e.Result + " Message:" + e.Message + " DataCount:" + e.DataCount);
            if(e.Result == ResultEvent.FinalResult)
            {
                if(e.DataCount > 0)
                {
                    _label.Text = String.Concat(e.Data);
                }
                else
                {
                    _label.Text = "No Recognized Text";
                }
            }
        }

        ~MainPage()
        {
            _sttInst.Unprepare();
            _sttInst.StateChanged -= _sttInst_StateChanged;
            _sttInst.RecognitionResult -= _sttInst_RecognitionResult;
        }

        private void _sttInst_StateChanged(object sender, StateChangedEventArgs e)
        {
            global::Tizen.Log.Info("STTDemo", " Previous:" + e.Previous + " Current:" + e.Current);
        }
    }
}