(function( $, undefined ) {

$.widget( "mobile.page", $.mobile.widget, {
	options: {
		theme: "c",
		domCache: false,
		keepNativeDefault: ":jqmData(role='none'), :jqmData(role='nojs')"
	},

	_create: function() {
		
		var self = this;
		
		// if false is returned by the callbacks do not create the page
		if ( self._trigger( "beforecreate" ) === false ) {
			return false;
		}

		self.element
			.addClass( "ui-page ui-body-" + self.options.theme )
			.bind( "pagebeforehide", function() {
				self.removeContainerBackground();
			} )
			.bind( "pagebeforeshow", function() {
				self.setContainerBackground();
			} );

	},
	
	refresh: function() {
		$( this.element ).children( ".ui-content" ).trigger("updatelayout", ["external"]);
	},

	/* GUI Builder only : redesign page when user drag&drop header, footer */
	setToolbar: function () {
		$( this.element ).trigger( "pagebeforeshow" );
	},

	removeContainerBackground: function() {
		$.mobile.pageContainer.removeClass( "ui-overlay-" + $.mobile.getInheritedTheme( this.element.parent() ) );
	},
	
	// set the page container background to the page theme
	setContainerBackground: function( theme ) {
		if ( this.options.theme ) {
			$.mobile.pageContainer.addClass( "ui-overlay-" + ( theme || this.options.theme ) );
		}
	},

	addBackBtn : function ( target ) {
		var $dest = $( ".ui-page-active .ui-footer" );

		if ( target == "header" ) {
			$dest = $( ".ui-page-active .ui-header" );
		}
		backBtn = $( "<a href='#' class='ui-btn-back' data-" + $.mobile.ns + "rel='back'></a>" )
			.buttonMarkup( {icon: "header-back-btn", theme : "s"} );
		if ( !$dest.find( ".ui-btn-back").length ) {
			backBtn.prependTo( $dest );
		}
	},

	keepNativeSelector: function() {
		var options = this.options,
			keepNativeDefined = options.keepNative && $.trim( options.keepNative );

		if ( keepNativeDefined && options.keepNative !== options.keepNativeDefault ) {
			return [options.keepNative, options.keepNativeDefault].join( ", " );
		}

		return options.keepNativeDefault;
	}
});
})( jQuery );
