//Initialize function
var transId = 1;
var config = {};
var processItem = function(data, prefix, purchased) {
	var name = data[prefix + '_itemName'] + '';
	name = name.substr(0, 25);

	var price = data[prefix + '_itemPrice'] + '';
	var separator = '';
	if (price.indexOf('.', 0) > -1) {
		separator = '.'
	} else if (price.indexOf(',', 0) > -1) {
		separator = ','
	}

	if (separator != '') {
		price = price.split(separator);
		price = price[0] + '.' + price[1].substr(0, 2);
	}

	var row = '';
	if (purchased) {
		row = '<li id="label"><a href="#">' + name + '...</a></li>';
	} else {
		row = '<li id="label"><a href="javascript:purchaseItem(\''
				+ data[prefix + '_itemId'] + '\', \''
				+ data[prefix + '_itemGroupId'] + '\', \''
				+ data['_transactionId'] + '\')">' + name + '</a> ' + price
				+ ' ' + data[prefix + '_currencyUnit'] + '</li>';
	}
	console.log(row);
	return row;
}
var processCountry = function(data, prefix) {
	var name = data[prefix + '_countryName'] + '';
	var mcc = data[prefix + '_mcc'] + '';
	row = '<li id="lic"><input id="c' + prefix
			+ '" type="radio" name="mcc" value="' + mcc + '"/>' + name
			+ '</li>';
	return row;
};
var handleSuccessPurchase = function(purchasedItemInformation) {
	alert('Succesfully purchased an item: '
			+ purchasedItemInformation._itemName);
}

var handlePurchasedItemList = function(itemInformationList) {
	var startNumber = parseInt(itemInformationList._startNumber);
	var endNumber = parseInt(itemInformationList._endNumber) + 1;
	var row = '';
	for ( var i = startNumber; i < endNumber; i++) {
		row += processItem(itemInformationList, i, true);
	}
	$('#iap_result_list').empty().append(row).listview('refresh');
}
var handleItemList = function(itemInformationList) {
	var startNumber = parseInt(itemInformationList._startNumber);
	var endNumber = parseInt(itemInformationList._endNumber) + 1;
	var row = '';
	for ( var i = startNumber; i < endNumber; i++) {
		row += processItem(itemInformationList, i);
	}
	$('#iap_result_list').empty().append(row).listview('refresh');
}

var handleCountryList = function(countryList) {
	var startNumber = parseInt(countryList._startNumber);
	var endNumber = parseInt(countryList._endNumber) + 1;
	var row = '';
	for ( var i = startNumber; i < endNumber; i++) {
		row += processCountry(countryList, i);
	}
	console.log(row);
	$('#countrylist').empty().append(row).listview('refresh');
	$('#countrylist').show();
}

function checkStatus(statusCode) {
	var iStatusCode = parseInt(statusCode, 10)

	switch (iStatusCode) {
	case 0:
		return true;
		break;
	case 100:
		alert('Request cancelled');
		break;
	case 200:
		alert('Network error occured');
		break;
	case 9000:
		alert('Process error occured');
		break;
	case 9200:
		alert('Service Unavailable');
		break;
	case 9201:
		alert('Item GroupId NotFound');
		break;
	case 9203:
		alert('PaymentId Not Found');
		break;
	case 9207:
		alert('ItemId Not Found');
		break;
	default:
		alert('Unknown error ' + statusCode);
		break;
	}
	return false;
}
var IapListener = {
	OnItemInformationListReceived : function(transactionId, statusCode,
			itemInformationList) {
		console.log("OnItemInformationListReceived: " + statusCode);
		if (checkStatus(statusCode)) {
			handleItemList(itemInformationList);
		}
	},
	OnPurchasedItemInformationListReceived : function(transactionId,
			statusCode, purchasedItemInformationList) {
		console.log("OnItemInformationListReceived: " + statusCode);
		if (checkStatus(statusCode)) {
			handlePurchasedItemList(purchasedItemInformationList);
		}
	},
	OnPurchaseItemInitialized : function(transactionId, statusCode,
			purchaseTicket) {
		// here you can use an purchaseTicket to verify the purchase
		return true;
	},
	OnPurchaseItemFinished : function(transactionId, statusCode,
			purchasedItemInformation) {
		if (checkStatus(statusCode)) {
			handleSuccessPurchase(purchasedItemInformation);
		}
	},
	OnCountryListReceived : function(transactionId, statusCode, countryList) {
		if (checkStatus(statusCode)) {
			handleCountryList(countryList);
		}
	}
}

var purchaseItem = function(_itemId, _itemGroupId, _transactionId) {
	var data = {};
	data['_itemId'] = _itemId;
	data['_itemGroupId'] = _itemGroupId;
	data['_transactionId'] = transId++;
	data['_mode'] = config.mode;
	data['_mcc'] = config.mcc;
	data['_mnc'] = config.mnc;
	data['_deviceModel'] = config.deviceModel;
	console.log(data);
	iap.RequestPurchaseItem(data);
}
var getCountryList = function() {
	var data = {};
	data['_transactionId'] = transId++;
	iap.RequestGetCountryList(data);
}
var init = function() {
	iap.RegisterCallback(IapListener);
	$("#main .ui-btn-back").on("vclick", function() {
		console.log('bye');
		var currentApp = tizen.application.getCurrentApplication();
		currentApp.exit();
	});
	$('#iap_get_available').bind("click", function(event) {
		var data = {}
		data['_transactionId'] = transId++;
		data['_startNumber'] = 1;
		data['_endNumber'] = 15;
		data['_itemGroupId'] = config.itemGroupId;
		data['_mode'] = config.mode;
		data['_mcc'] = config.mcc;
		data['_mnc'] = config.mnc;
		data['_deviceModel'] = config.deviceModel;
		iap.RequestItemInformationList(data);
	})
	$('#iap_get_purchased').bind("click", function(event) {
		var data = {}
		data['_transactionId'] = transId++;
		data['_startNumber'] = 1;
		data['_endNumber'] = 15;
		data['_itemGroupId'] = config.itemGroupId;
		data['_mode'] = config.mode;
		data['_mcc'] = config.mcc;
		data['_mnc'] = config.mnc;
		data['_deviceModel'] = config.deviceModel;
		iap.RequestPurchasedItemInformationList(data);
	})
	$('#configure').bind(
			"click",
			function(event) {
				config.deviceModel = document.getElementById('model').value;
				config.mnc = document.getElementById('mnc').value;
				config.mode = document.getElementById('r1').checked ? 1
						: document.getElementById('r2').checked ? 0 : -1;
				if (config.mode == 1) {
					config.mcc = $("input[name='mcc']:checked").val();
				} else {
					config.mnc = '';
					config.mcc = '';
				}
				config.itemGroupId = '100000001455'; // '100000000001': (검증) // '100000001455': (운영)  
				if (config.mcc == '' || config.mnc == '') {
					alert("Please select a country from the list!");
				} else {
					$.mobile.changePage('#main');
				}
			})
	$('#r1').bind("change", function(event) {
		if($('#r1').attr('checked')=='checked'){
			$('#countrylist').show();
		};
	})
	$('#r2').bind("change", function(event) {
		if($('#r2').attr('checked')=='checked'){
			$('#countrylist').hide();
		};
	})
	getCountryList();
	console.log("init() called");
};