#include <FGrpRectangle.h>
#include <FGrpDimension.h>
#include <FUiCtrlListView.h>
#include <FUiCtrlCustomItem.h>

#include "ui/ItemListProvider.h"

using Tizen::Ui::Controls::ListView;
using Tizen::Ui::Controls::IListViewItemProvider;
using Tizen::Ui::Controls::ListItemBase;
using Tizen::Ui::Controls::CustomItem;
using Tizen::Graphics::Rectangle;
using Tizen::Graphics::Dimension;

#define LIST_ITEM_HEIGHT 112
#define LIST_ITEM_FONT_SIZE 44
#define LIST_ITEM_FONT_SUB_SIZE 32
#define LIST_ITEM_PRICE_WIDTH 170

ItemListProvider::ItemListProvider()
    : IListViewItemProvider()
    , __eMode(ItemListProvider::ItemInformation)
    , __pListView(null)
{
}

result ItemListProvider::Construct(Tizen::Ui::Controls::ListView* listView)
{
    result retVal = E_INVALID_ARG;

    if ( listView != null ) {
        if ( __pListView == null ) {
            // set this as item provider and save result of operation
            retVal = listView->SetItemProvider(*this);

            if ( ! IsFailed(retVal) ) {
                // save our ListView for later use
                __pListView = listView;
            }
        }
        else {
            retVal = E_ALREADY_SET;
        }
    }

    return retVal;
}

ItemListProvider::~ItemListProvider()
{
    __itemInformationList.RemoveAll();
    __purchasedItemInformationList.RemoveAll();
    __pListView = null;
}

result ItemListProvider::SetItemInformationList(const BuyItemInformationList& aList)
{
    result retVal = E_INVALID_STATE;

    if ( __pListView ) {
        // clear existing items
        ClearAll();
        // switch working mode
        __eMode = ItemListProvider::ItemInformation;
        // fill item list
        retVal = __itemInformationList.Construct(aList);

        // if list was filled with no error
        if ( ! IsFailed(retVal) ) {
            // and refresh UI list content
            __pListView->UpdateList();
            // than ask to redraw the UI list
            __pListView->RequestRedraw(true);
        }
    }

    return retVal;
}

result ItemListProvider::SetPurchasedItemInformationList(const BuyPurchasedItemInformationList& aList)
{
    result retVal = E_INVALID_STATE;

    if ( __pListView ) {
        // clear existing items
        ClearAll();
        // switch working mode
        __eMode = ItemListProvider::PurchasedItemInformation;
        // fill item list
        retVal = __purchasedItemInformationList.Construct(aList);

        // if list was filled with no error
        if ( ! IsFailed(retVal) ) {
            // and refresh UI list content
            __pListView->UpdateList();
            // than ask to redraw the UI list
            __pListView->RequestRedraw(true);
        }
    }

    return retVal;
}

result ItemListProvider::GetItemInformationAt(int aIndex, BuyItemInformation& aOut) const
{
    result retVal = E_INVALID_STATE;

    if ( __pListView && __eMode == ItemListProvider::ItemInformation) {
        if (aIndex >= __itemInformationList.GetCount()) {
            retVal = E_OUT_OF_RANGE;
        }
        else {
            retVal = __itemInformationList.GetAt(aIndex, aOut);
        }
    }

    return retVal;
}

void ItemListProvider::ClearAll()
{
    __eMode = ItemListProvider::ItemInformation;
    // clear both lists
    __itemInformationList.RemoveAll();
    __purchasedItemInformationList.RemoveAll();
    // refresh the UI list content
    __pListView->UpdateList();
    // than ask to redraw the list
    __pListView->RequestRedraw(true);
}

int ItemListProvider::GetItemCount(void)
{
    int retval = 0;

    switch (__eMode) {
    case ItemListProvider::ItemInformation:
        retval = __itemInformationList.GetCount();
        break;

    case ItemListProvider::PurchasedItemInformation:
        retval = __purchasedItemInformationList.GetCount();
        break;
    }

    // Number of items to display in UI, is a number of items received from the server.
    return retval;

}

Tizen::Ui::Controls::ListItemBase * ItemListProvider::CreateItem(int aIndex, int aItemWidth)
{
    // create item for the "aIndex" position on the list.

    // workaround, something is bad in 2.0.0RC2
    aItemWidth = __pListView->GetWidth();

    // by default return null
    ListItemBase * retval = null;

    switch ( __eMode ) {
    case ItemListProvider::ItemInformation:
        retval = CreateItemInformationListItem(aIndex, aItemWidth);
        break;

    case ItemListProvider::PurchasedItemInformation:
        retval = CreatePurchasedItemInformationListItem(aIndex, aItemWidth);
        break;
    }

    return retval;
}

bool ItemListProvider::DeleteItem(int index, Tizen::Ui::Controls::ListItemBase* pItem, int itemWidth)
{
    // let default handler delete everything
    return false;
}

Tizen::Ui::Controls::ListItemBase * ItemListProvider::CreateItemInformationListItem(int aIndex, int aItemWidth)
{
    ListItemBase * retval = null;
    // get the item from the list
    BuyItemInformation dataItem;

    if ( ! IsFailed(__itemInformationList.GetAt(aIndex, dataItem)) ) {
        // make new custom item
        CustomItem* pItem = new CustomItem();

        if( IsFailed(pItem->Construct(Dimension(aItemWidth, LIST_ITEM_HEIGHT), Tizen::Ui::Controls::LIST_ANNEX_STYLE_NORMAL)) ) {
            delete pItem;
        }
        else {
            int itemHalf = LIST_ITEM_HEIGHT / 2;

            pItem->AddElement(Rectangle(0, 0, aItemWidth - LIST_ITEM_PRICE_WIDTH, itemHalf), ItemListProvider::ItemDataName, dataItem.GetItemName());

            pItem->AddElement(Rectangle(aItemWidth - LIST_ITEM_PRICE_WIDTH, 0, LIST_ITEM_PRICE_WIDTH, LIST_ITEM_HEIGHT), ItemListProvider::ItemDataPrice, dataItem.GetItemPriceFormatted(true));

            retval = pItem;
        }
    }

    return retval;
}

Tizen::Ui::Controls::ListItemBase * ItemListProvider::CreatePurchasedItemInformationListItem(int aIndex, int aItemWidth)
{
    Tizen::Ui::Controls::ListItemBase * retval = null;
    // get the item from the list
    BuyPurchasedItemInformation dataItem;

    if ( ! IsFailed(__purchasedItemInformationList.GetAt(aIndex, dataItem)) ) {

        // make new custom item
        CustomItem* pItem = new CustomItem();
        if( IsFailed(pItem->Construct(Dimension(aItemWidth, LIST_ITEM_HEIGHT), Tizen::Ui::Controls::LIST_ANNEX_STYLE_NORMAL)) ) {
            delete pItem;
        }
        else {
            int itemHalf = LIST_ITEM_HEIGHT / 2;

            pItem->AddElement(Rectangle(0, 0, aItemWidth - LIST_ITEM_PRICE_WIDTH, itemHalf), ItemListProvider::ItemDataName, dataItem.GetItemName());

            pItem->AddElement(Rectangle(aItemWidth - LIST_ITEM_PRICE_WIDTH, 0, LIST_ITEM_PRICE_WIDTH, LIST_ITEM_HEIGHT), ItemListProvider::ItemDataPrice, dataItem.GetItemPriceFormatted(true));

            retval = pItem;
        }
    }

    return retval;
}
