#include <FBaseColHashMap.h>
#include <FBaseInteger.h>

//#include "lib/IapItemInformation.h"
//#include "buy/BuyAppControlRequest.h"
#include "buy/BuyUtils.h"

using namespace Tizen::Base;

result BuyHashMapUtils::GetStringValue(const Tizen::Base::Collection::IMap *aMap, const String &aKey,
        Tizen::Base::String &aOut)
{
    result retval = E_INVALID_ARG;

    if (aMap) {
        retval = E_KEY_NOT_FOUND;
        bool contains = false;
        aMap->ContainsKey(aKey, contains);

        if (contains) {
            const String * pVal = static_cast<const String *>(aMap->GetValue(aKey));
            aOut = *pVal;
            retval = E_SUCCESS;
        }
    }

    return retval;
}

result BuyHashMapUtils::GetBoolValue(const Tizen::Base::Collection::IMap *aMap, const String &aKey, bool &aOut)
{
    result retval = E_INVALID_ARG;

    if (aMap) {
        retval = E_KEY_NOT_FOUND;
        bool contains = false;
        aMap->ContainsKey(aKey, contains);

        if (contains) {
            static const String sBoolTrueValue(L"1");
            const String * pVal = static_cast<const String *>(aMap->GetValue(aKey));
            aOut = pVal->Equals(sBoolTrueValue);
            retval = E_SUCCESS;
        }
    }

    return retval;
}

result BuyHashMapUtils::GetIntegerValue(const Tizen::Base::Collection::IMap *aMap, const String &aKey, int &aOut)
{
    result retval = E_INVALID_ARG;

    if (aMap) {
        retval = E_KEY_NOT_FOUND;
        bool contains = false;
        aMap->ContainsKey(aKey, contains);

        if (contains) {
            const String * sVal = static_cast<const String *>(aMap->GetValue(aKey));
            retval = Integer::Parse(*sVal, aOut);
        } else {
            retval = E_KEY_NOT_FOUND;
        }
    }

    return retval;
}

result BuyHashMapUtils::GetDoubleValue(const Tizen::Base::Collection::IMap *aMap, const String &aKey, double &aOut)
{
    result retval = E_INVALID_ARG;

    if (aMap) {
        retval = E_KEY_NOT_FOUND;
        bool contains = false;
        aMap->ContainsKey(aKey, contains);

        if (contains) {
            const String * pVal = static_cast<const String *>(aMap->GetValue(aKey));
            retval = Double::Parse(*pVal, aOut);
        }
    }

    return retval;
}
