#include "buy/BuyPurchasedItemInformation.h"

using namespace Tizen::Base;

BuyPurchasedItemInformation::BuyPurchasedItemInformation()
{
}

BuyPurchasedItemInformation::BuyPurchasedItemInformation(const BuyPurchasedItemInformation & aOther)
    : BuyItemInformation(aOther), paymentId(aOther.paymentId), purchaseDate(aOther.purchaseDate)
{
}

BuyPurchasedItemInformation::BuyPurchasedItemInformation(const BuyItemInformation & aOther)
    : BuyItemInformation(aOther)
{
}

BuyPurchasedItemInformation::~BuyPurchasedItemInformation()
{
}

BuyPurchasedItemInformation & BuyPurchasedItemInformation::operator=(const BuyPurchasedItemInformation & aOther)
{
    if ( *this != aOther ) {
        BuyItemInformation::operator=(aOther);

        paymentId = aOther.paymentId;
        purchaseDate = aOther.purchaseDate;
    }

    return *this;
}

bool BuyPurchasedItemInformation::operator ==(const BuyPurchasedItemInformation & aOther) const
{
    bool retval = BuyItemInformation::operator==(aOther);

    if (retval) {
        retval =   paymentId == aOther.paymentId
                && purchaseDate == aOther.purchaseDate;
    }

    return retval;
}

bool BuyPurchasedItemInformation::operator !=(const BuyPurchasedItemInformation & aOther) const
{
    return ! operator==(aOther);
}

void BuyPurchasedItemInformation::SetPaymentId(const String & aPaymentId)
{
    paymentId = aPaymentId;
}

String BuyPurchasedItemInformation::GetPaymentId() const
{
    return paymentId;
}

void BuyPurchasedItemInformation::SetPurchaseDate(const DateTime & aPurchaseDate)
{
    purchaseDate = aPurchaseDate;
}

DateTime BuyPurchasedItemInformation::GetPurchaseDate() const
{
    return purchaseDate;
}
