#include <FBaseDouble.h>

#include "buy/BuyItemInformation.h"

using namespace Tizen::Base;


// Template to generate properly formated price string with currency
template<class T>
Tizen::Base::String FormatPrice(const T & type, bool aWithCurrency)
{
    Tizen::Base::String sRetval;
    Tizen::Base::String sPrice;

    if (type.GetCurrencyUnitHasPenny()) {
        sPrice.Format(255, L"%.2f", type.GetItemPrice());
    }
    else {
        sPrice.Format(255, L"%.0f", type.GetItemPrice());
    }

    if (aWithCurrency) {
        if (type.GetCurrencyUnitPrecedes()) {
            sRetval = type.GetCurrencyUnit() + sPrice;
        }
        else {
            sRetval = sPrice + type.GetCurrencyUnit();
        }
    }
    else {
        sRetval = sPrice;
    }

    return sRetval;
}

BuyItemInformation::BuyItemInformation() //
    : currencyUnitPrecedes(true) //
    , currencyUnitHasPenny(true) //
    , itemPrice(-1) //
{
}

BuyItemInformation::BuyItemInformation(const BuyItemInformation &aOther)
{
    *this = aOther;
}

BuyItemInformation::~BuyItemInformation()
{
}

BuyItemInformation & BuyItemInformation::operator=(const BuyItemInformation &aOther)
{
    if ( aOther != *this ) {
        itemId = aOther.itemId;
        itemGroupId = aOther.itemGroupId;
        itemName = aOther.itemName;
        currencyUnit = aOther.currencyUnit;
        currencyUnitPrecedes = aOther.currencyUnitPrecedes;
        currencyUnitHasPenny = aOther.currencyUnitHasPenny;
        itemPrice = aOther.itemPrice;
        itemDownloadUrl = aOther.itemDownloadUrl;
        itemImageUrl = aOther.itemImageUrl;
        itemDescription = aOther.itemDescription;
        reserved1 = aOther.reserved1;
        reserved2 = aOther.reserved2;
    }

    return *this;
}

bool BuyItemInformation::operator ==(const BuyItemInformation & aOther) const
{
    return this->Equals(aOther);
}

bool BuyItemInformation::operator !=(const BuyItemInformation & aOther) const
{
    return ! operator==(aOther);
}

bool BuyItemInformation::Equals(const BuyItemInformation & aOther) const
{
    return     itemId == aOther.itemId
            && itemGroupId == aOther.itemGroupId
            && itemName == aOther.itemName
            && currencyUnit == aOther.currencyUnit
            && currencyUnitPrecedes == aOther.currencyUnitPrecedes
            && currencyUnitHasPenny == aOther.currencyUnitHasPenny
            && Double::Compare(itemPrice, aOther.itemPrice) == 0
            && itemDownloadUrl == aOther.itemDownloadUrl
            && itemImageUrl == aOther.itemImageUrl
            && itemDescription == aOther.itemDescription;
}

void BuyItemInformation::SetItemId(const String &aItemId)
{
    itemId = aItemId;
}

String BuyItemInformation::GetItemId() const
{
    return itemId;
}

void BuyItemInformation::SetItemGroupId(const Tizen::Base::String & aItemGroupId)
{
    itemGroupId = aItemGroupId;
}

Tizen::Base::String BuyItemInformation::GetItemGroupId() const
{
    return itemGroupId;
}

void BuyItemInformation::SetItemName(const String & aItemName)
{
    itemName = aItemName;
}

String BuyItemInformation::GetItemName() const
{
    return itemName;
}

void BuyItemInformation::SetCurrencyUnit(const String & aCurrencyUnit)
{
    currencyUnit = aCurrencyUnit;
}

String BuyItemInformation::GetCurrencyUnit() const
{
    return currencyUnit;
}

void BuyItemInformation::SetCurrencyUnitPrecedes(bool aCurrencyUnitPrecedes)
{
    currencyUnitPrecedes = aCurrencyUnitPrecedes;
}

bool BuyItemInformation::GetCurrencyUnitPrecedes() const
{
    return currencyUnitPrecedes;
}

void BuyItemInformation::SetCurrencyUnitHasPenny(bool aCurrencyUnitHasPenny)
{
    currencyUnitHasPenny = aCurrencyUnitHasPenny;
}

bool BuyItemInformation::GetCurrencyUnitHasPenny() const
{
    return currencyUnitHasPenny;
}

void BuyItemInformation::SetItemPrice(double aItemPrice)
{
    itemPrice = aItemPrice;
}

double BuyItemInformation::GetItemPrice() const
{
    return itemPrice;
}

Tizen::Base::String BuyItemInformation::GetItemPriceFormatted(bool aWithCurrency) const
{
    return FormatPrice(*this, aWithCurrency);
}

void BuyItemInformation::SetItemDownloadUrl(const String & aItemDownloadUrl)
{
    itemDownloadUrl = aItemDownloadUrl;
}

String BuyItemInformation::GetItemDownloadUrl() const
{
    return itemDownloadUrl;
}

void BuyItemInformation::SetItemImageUrl(const String & aItemImageUrl)
{
    itemImageUrl = aItemImageUrl;
}

String BuyItemInformation::GetItemImageUrl() const
{
    return itemImageUrl;
}

void BuyItemInformation::SetItemDescription(const String & aItemDescription)
{
    itemDescription = aItemDescription;
}

String BuyItemInformation::GetItemDescription() const
{
    return itemDescription;
}

void BuyItemInformation::SetReserved1(const String & aReserved1)
{
    reserved1 = aReserved1;
}

String BuyItemInformation::GetReserved1() const
{
    return reserved1;
}

void BuyItemInformation::SetReserved2(const String & aReserved2)
{
    reserved2 = aReserved2;
}

String BuyItemInformation::GetReserved2() const
{
    return reserved2;
}
