#include <FBaseInteger.h>
#include <FBaseColHashMap.h>
#include <FAppAppManager.h>
#include <FAppAppControl.h>
#include <FSysSystemInfo.h>

#include "buy/BuyAppControlTypes.h"
#include "buy/BuyAppControlRequest.h"
#include "buy/BuyAppControlSerialization.h"
#include "buy/BuyItemInformation.h"

using namespace BuyAppControlSerialization;
using namespace Tizen::Base;
using namespace Tizen::App;

BuyAppControlRequest::BuyAppControlRequest() //
    : m_pHashMap(null)
{
}

BuyAppControlRequest::~BuyAppControlRequest()
{
    if (m_pHashMap) {
        m_pHashMap->RemoveAll(true);
        delete m_pHashMap;
    }
}

result BuyAppControlRequest::Construct(const Tizen::Base::String &operation, int capacity)
{
    result retval = E_INVALID_ARG;

    if ( ! operation.IsEmpty() && capacity >= 0) {
        retval = E_ALREADY_SET;

        if ( m_pHashMap == null && m_sOperation.IsEmpty() ) {
            m_sOperation = operation;
            m_pHashMap = new Collection::HashMap();
            retval = m_pHashMap->Construct(capacity);
            TryReturn(retval == E_SUCCESS, retval, GetErrorMessage(retval));
        }
    }

    return retval;
}

result BuyAppControlRequest::Construct(const Tizen::Base::String &operation, BuyConfigInfo info, int capacity)
{
    result retval = E_INVALID_ARG;

    if ( ! operation.IsEmpty() && capacity >= 0) {
        retval = E_ALREADY_SET;

        if ( m_pHashMap == null && m_sOperation.IsEmpty() ) {
            m_sOperation = operation;
            m_pHashMap = new Collection::HashMap();
            retval = m_pHashMap->Construct(capacity + 7); // extra fields for bogus settings
            TryReturn(retval == E_SUCCESS, retval, GetErrorMessage(retval));

            //TODO to be removed from production code -->
            // bogus data for Poland T-Mobile
            retval = Add(BUY_APPCTRL_KEY_MCC, info.m_mcc);
            TryReturn(retval == E_SUCCESS, retval, GetErrorMessage(retval));
            retval = Add(BUY_APPCTRL_KEY_MNC, info.m_mnc);
            TryReturn(retval == E_SUCCESS, retval, GetErrorMessage(retval));
            retval = Add(BUY_APPCTRL_KEY_DEVICE_MODEL, info.m_model);
            TryReturn(retval == E_SUCCESS, retval, GetErrorMessage(retval));
            // <-- remove

            retval = Add(BUY_APPCTRL_KEY_MODE, info.m_developerFlag);
            TryReturn(retval == E_SUCCESS, retval, GetErrorMessage(retval));
        }
    }

    return retval;
}

result BuyAppControlRequest::Add(const wchar_t *key, const wchar_t *value)
{
    result retval = E_FAILURE;

    if ( ! m_sOperation.IsEmpty() ) {
        retval = m_pHashMap->Add(new String(key), new String(value));
    }

    return retval;
}

result BuyAppControlRequest::Add(const wchar_t *key, int value)
{
    result retval = E_FAILURE;

    if ( ! m_sOperation.IsEmpty() ) {
        String * sVal = new String();
        retval = sVal->Append(value);
        TryReturn(retval == E_SUCCESS, retval, "Preparing value");
        retval = m_pHashMap->Add(new String(key), sVal);
    }

    return retval;
}

result BuyAppControlRequest::Add(const wchar_t *key, const Tizen::Base::String &value)
{
    result retval = E_FAILURE;

    if ( ! m_sOperation.IsEmpty() ) {
        String * sVal = new String(value);
        retval = m_pHashMap->Add(new String(key), sVal);
    }

    return retval;
}

result BuyAppControlRequest::Send(IAppControlResponseListener * aListener)
{
    result retval = E_FAILURE;

    if ( ! m_sOperation.IsEmpty() ) {
        String appid = BUY_APPCTRL_CLIENTID;

        if ( m_sOperation == BUY_APPCTRL_OP_GET_ITEM_LIST
             || m_sOperation == BUY_APPCTRL_OP_GET_PURCHASED_ITEM_LIST
             || m_sOperation == BUY_APPCTRL_OP_GET_COUNTRY_LIST )
        {
            appid = BUY_APPCTRL_SERVICEID;
        }

        AppLog("AppId: %S", appid.GetPointer());
        AppControl* pAc = AppManager::FindAppControlN(appid, m_sOperation);

        retval = E_APP_NOT_INSTALLED;

        if (pAc) {
            retval = pAc->Start(null, null, m_pHashMap, aListener);
            delete pAc;
        }
    }

    AppLog("Send result: %s", GetErrorMessage(retval));
    return retval;
}
