#ifndef _ItemListProvider_H_
#define _ItemListProvider_H_

#include <FUiCtrlIListViewItemProvider.h>

#include "buy/BuyItemInformation.h"
#include "buy/BuyPurchasedItemInformation.h"

namespace Tizen
{
    namespace Ui
    {
        namespace Controls
        {
            class ListView;
        }
    }
}

class ItemListProvider: public Tizen::Ui::Controls::IListViewItemProvider
{
public:
    enum Mode
    {
        ItemInformation,
        PurchasedItemInformation
    };

    enum ElementId
    {
        ItemDataName = 401,
        ItemDataPrice,
        ItemDataDesc,
        ItemDataPaymentId
    };

public:
    ItemListProvider();

    result Construct(Tizen::Ui::Controls::ListView * listView);

    virtual ~ItemListProvider();

    result SetItemInformationList(const BuyItemInformationList & aList);

    result SetPurchasedItemInformationList(const BuyPurchasedItemInformationList & aList);

    ItemListProvider::Mode GetCurrentMode() const { return __eMode; }

    result GetItemInformationAt(int aIndex, BuyItemInformation &aOut) const;

    void ClearAll();

public:
    // From Tizen::Ui::Controls::IListViewItemProvider
    virtual int GetItemCount(void);

    virtual Tizen::Ui::Controls::ListItemBase* CreateItem(int aIndex, int aItemWidth);

    virtual bool DeleteItem(int index, Tizen::Ui::Controls::ListItemBase* pItem, int itemWidth);

private:
    Tizen::Ui::Controls::ListItemBase* CreateItemInformationListItem(int aIndex, int aItemWidth);

    Tizen::Ui::Controls::ListItemBase* CreatePurchasedItemInformationListItem(int aIndex, int aItemWidth);

private:
    BuyItemInformationList __itemInformationList;

    BuyPurchasedItemInformationList __purchasedItemInformationList;

    ItemListProvider::Mode __eMode;

    Tizen::Ui::Controls::ListView * __pListView;
};

#endif // _ItemListProvider_H_
