#ifndef _ConfigForm_H_
#define _ConfigForm_H_

#include <FUiCtrlForm.h>
#include <FBaseColArrayListT.h>
#include <FUiCtrlRadioGroup.h>
#include <FUiIActionEventListener.h>
#include <FUiCtrlEditField.h>
#include <FUiCtrlITableViewItemProvider.h>

#include "buy/BuyEngine.h"
#include "buy/BuyConfigInfo.h"
#include "buy/BuyEngine.h"
#include "buy/BuyListener.h"
#include "buy/BuyConfigInfo.h"

class ConfigForm
    : public Tizen::Ui::Controls::Form
    , public Tizen::Ui::IActionEventListener
    , public BuyListener
    , public Tizen::Ui::Controls::ITableViewItemProvider
    , public Tizen::Ui::Controls::ITableViewItemEventListener
{
public:
    result Construct(Tizen::Ui::IActionEventListener * mainListener);
    ConfigForm();
    virtual ~ConfigForm();

public:
    // Tizen::Ui::Controls::ITableViewItemEventListener
    virtual void  OnTableViewContextItemActivationStateChanged(
                                        Tizen::Ui::Controls::TableView &tableView,
                                        int itemIndex,
                                        Tizen::Ui::Controls::TableViewContextItem *pContextItem,
                                        bool activated) {};
    virtual void  OnTableViewItemReordered(
                                        Tizen::Ui::Controls::TableView &tableView,
                                        int itemIndexFrom,
                                        int itemIndexTo) {}
    virtual void  OnTableViewItemStateChanged(
                                        Tizen::Ui::Controls::TableView &tableView,
                                        int itemIndex,
                                        Tizen::Ui::Controls::TableViewItem *pItem,
                                        Tizen::Ui::Controls::TableViewItemStatus status);

    // Tizen::Ui::Controls::ITableViewItemProvider
    virtual int GetItemCount(void);
    virtual Tizen::Ui::Controls::TableViewItem* CreateItem(int itemIndex, int itemWidth);
    virtual bool DeleteItem(int itemIndex, Tizen::Ui::Controls::TableViewItem* pItem);
    virtual void UpdateItem(int itemIndex, Tizen::Ui::Controls::TableViewItem* pItem);
    virtual int GetDefaultItemHeight(void);

    BuyConfigInfo GetConfigInfo() const;

    void OnCountryListReceived(int aTransactionId, StatusCode aStatusCode,
            const Tizen::Base::Collection::HashMap * countryList);

public:
    void OnActionPerformed(const Tizen::Ui::Control& source, int actionId);

private:
    // enable/disable confirm button when specific conditions are changed
    void UpdateConfirmButtonState();

private:
    // DO NOT OWN
    Tizen::Ui::Controls::RadioGroup * __pDevRadioGroup;

    // DO NOT OWN
    Tizen::Ui::IActionEventListener * __pMainListener;

    // DO NOT OWN
    Tizen::Ui::Controls::EditField * __pModelEditField;

    // DO NOT OWN
    Tizen::Ui::Controls::EditField * __pMccEditField;

    // DO NOT OWN
    Tizen::Ui::Controls::EditField * __pMncEditField;

    // Engine instance
    BuyEngine * __pEngine;

    // Do not own
    Tizen::Ui::Controls::TableView * m_pTableView;

    Tizen::Base::Collection::IList * m_pCountryList;

    Tizen::Base::Collection::IList * m_pMccList;

    Tizen::Base::String m_mcc;

    BuyConfigInfo::DeveloperFlag m_developerFlag;
};

#endif // _ConfigForm_H_
