/*
 * BuyUtils.h
 *
 *  Created on: Oct 11, 2012
 *      Author: sprc
 */

#ifndef _BUY_UTILS_H_
#define _BUY_UTILS_H_

#include <FBaseString.h>
#include <FBaseDateTime.h>
#include <FBaseColHashMap.h>
#include <FBaseColArrayListT.h>

template<class Type>
void ArrayListTDeleteAll(Tizen::Base::Collection::ArrayListT<Type *> &array)
{
    for(int i = 0; i < array.GetCount(); ++i) {
        Type *tmp;
        result res = array.GetAt(i, tmp);

        if ( ! IsFailed(res) ) {
            delete tmp;
        }
    }
}

namespace BuyHashMapUtils
{
    // Extracts aKey from aMap and stores in aOut as Tizen::Base::String
    result GetStringValue(const Tizen::Base::Collection::IMap *aMap, const Tizen::Base::String &aKey,
            Tizen::Base::String &aOut);

    inline result GetStringValue(const Tizen::Base::Collection::IMap *aMap, const wchar_t *aKey,
            Tizen::Base::String &aOut)
    {
        return GetStringValue(aMap, Tizen::Base::String(aKey), aOut);
    }

    // Extracts aKey from aMap and stores in aOut as bool
    result GetBoolValue(const Tizen::Base::Collection::IMap *aMap, const Tizen::Base::String &aKey, bool &aOut);

    // Extracts aKey from aMap and stores in aOut as int
    result GetIntegerValue(const Tizen::Base::Collection::IMap *aMap, const Tizen::Base::String &aKey, int &aOut);

    inline result GetIntegerValue(const Tizen::Base::Collection::IMap *aMap, const wchar_t *aKey, int &aOut)
    {
        return GetIntegerValue(aMap, Tizen::Base::String(aKey), aOut);
    }

    // Extracts aKey from aMap and stores in aOut as double
    result GetDoubleValue(const Tizen::Base::Collection::IMap *aMap, const Tizen::Base::String &aKey, double &aOut);

}

#endif // _BUY_UTILS_H_
