#ifndef _BUYITEMLIST_H_
#define _BUYITEMLIST_H_

#include <FBaseColArrayListT.h>

template <class Type>
class BuyItemList : public Tizen::Base::Collection::ArrayListT <Type>
{
public:
    BuyItemList()
        : __startNum(-1)
        , __endNum(-1)
        , __totalCount(-1)
    {
    }

    inline result Construct(int aStartNum, int aEndNum, int aTotalCount)
    {
        result retval = E_INVALID_ARG;

        if (aStartNum > -1 && aEndNum > -1 && aTotalCount > -1) {
            if (__startNum != -1 && __endNum != -1 && __totalCount != -1) {
                retval = E_ALREADY_SET;
            }
            else {
                __startNum = aStartNum;
                __endNum = aEndNum;
                __totalCount = aTotalCount;
                retval = E_SUCCESS;
            }
        }

        return retval;
    }

    inline result Construct(const BuyItemList<Type> &aList)
    {
        Tizen::Base::Collection::ArrayListT<Type>::RemoveAll();
        __startNum = aList.__startNum;
        __endNum = aList.__endNum;
        __totalCount = aList.__totalCount;
        Tizen::Base::Collection::ArrayListT<Type>::AddItems(aList);
        return E_SUCCESS;
    }

    void Reset()
    {
        Tizen::Base::Collection::ArrayListT<Type>::RemoveAll();
        __startNum = -1;
        __endNum = -1;
        __totalCount = -1;
    }

    bool IsValid() const
    {
        return __totalCount >= 0;
    }

    inline int GetStartNum() const
    {
        return __startNum;
    }

    inline int GetEndNum() const
    {
        return __endNum;
    }

    inline int GetTotalCount() const
    {
        return __totalCount;
    }

    inline result AddNextPart(const BuyItemList<Type> &other)
    {
        result retval = E_INVALID_ARG;

        if (other.GetCount() > 0 && other.GetTotalCount() == __totalCount && other.GetStartNum() == __endNum + 1) {
            retval = Tizen::Base::Collection::ArrayListT<Type>::AddItems(other);

            if ( ! IsFailed(retval) ) {
                __endNum = other.GetEndNum();
            }
        }

        return retval;
    }

private:
    // Start index as given in construct. Intention is not to update it on adding/removing items.
    int __startNum;
    // End index as given in construct. Intention is not to update it on adding/removing items.
    int __endNum;
    // full number of items of a list available on the server
    int __totalCount;
};

#endif // _BUYITEMLIST_H_
