/*
 * BuyEngine.h
 *
 *  Created on: May 17, 2013
 *      Author: sprc
 */

#ifndef BUYENGINE_H_
#define BUYENGINE_H_

#include <FAppTypes.h>
#include <FAppIAppControlResponseListener.h>
#include <FBaseString.h>
#include <FBaseColIMap.h>

#include "buy/BuyConfigInfo.h"
#include "buy/BuyItemInformation.h"

class BuyListener;

class BuyEngine : public Tizen::App::IAppControlResponseListener
{
public:
    BuyEngine(BuyListener * aListener, const BuyConfigInfo & info);
    virtual ~BuyEngine();

public:
    // from Tizen::App::IAppControlResponseListener
    virtual void OnAppControlCompleteResponseReceived(const Tizen::App::AppId& appId, const Tizen::Base::String& operationId,
            Tizen::App::AppCtrlResult appControlResult, const Tizen::Base::Collection::IMap* pExtraData);

public:
    result RequestPurchaseItem(int aTransactionId, const BuyItemInformation &);

    result RequestItemInformationList(int aTransactionId, int aStartNum, int aEndNum);

    result RequestCountryList(int aTransactionId);

    result RequestPurchasedItemInformationList(int aTransactionId, int aStartNum, int aEndNum);

private:
    BuyConfigInfo __configInfo;

    BuyListener * __pListener;
};

#endif /* BUYENGINE_H_ */
