#include "ui/SampleNativeFormFactory.h"
#include "ui/SampleNativeSceneConsts.h"
#include "ui/ConfigForm.h"
#include "ui/MainForm.h"


using namespace Tizen::Ui::Scenes;

SampleNativeFormFactory::SampleNativeFormFactory(void)
{
}

SampleNativeFormFactory::~SampleNativeFormFactory(void) {
}

Tizen::Ui::Controls::Form*
SampleNativeFormFactory::CreateFormN(const Tizen::Base::String& formId, const Tizen::Ui::Scenes::SceneId& sceneId) {
    Tizen::Ui::Controls::Form* pNewForm = null;


    if (formId == FORM_MAIN) {
        MainForm * pForm = new MainForm;
        pForm->Construct(m_configInfo);\
        pNewForm = pForm;
    } else if (formId == FORM_CONFIG) {
        ConfigForm * pForm = new ConfigForm;
        pForm->Construct(this);
        pNewForm = pForm;
    }

    if (pNewForm) {
        pNewForm->SetBackgroundColor(Tizen::Graphics::Color(0x93, 0xc5, 0x72));
    }

    return pNewForm;
}

void SampleNativeFormFactory::OnActionPerformed(const Tizen::Ui::Control &source, int actionId)
{
    const ConfigForm * pForm = reinterpret_cast<const ConfigForm *>(&source);

    if (pForm) {
        m_configInfo = pForm->GetConfigInfo();
    }

    SceneManager* pSceneManager = SceneManager::GetInstance();
    AppAssert(pSceneManager);

    pSceneManager->GoForward(ForwardSceneTransition(SCENE_MAIN, SCENE_TRANSITION_ANIMATION_TYPE_LEFT));
}
