#include <FUiVerticalBoxLayout.h>
#include <FUiCtrlRadioGroup.h>
#include <FUiCtrlLabel.h>
#include <FUiCtrlCheckButton.h>
#include <FGrpRectangle.h>
#include <FAppAppManager.h>
#include <FAppAppControl.h>
#include <FUiCtrlTableView.h>
#include <FGraphics.h>

#include "ui/ConfigForm.h"

#define ITEM_HEIGHT 112

using namespace Tizen::Telephony;
using namespace Tizen::Base;
using namespace Tizen::Base::Collection;
using namespace Tizen::Ui;
using namespace Tizen::Ui::Controls;
using namespace Tizen::Graphics;
using namespace Tizen::App;

result ConfigForm::Construct(IActionEventListener * mainListener)
{
    VerticalBoxLayout layout;
    layout.Construct(VERTICAL_DIRECTION_DOWNWARD);
    Form::Construct(layout, FORM_STYLE_NORMAL | FORM_STYLE_FOOTER);

    Label * label = new Label();
    label->Construct(Rectangle(0, 0, 48, 50), L"Device model:");
    AddControl(*label);
    layout.SetHorizontalFitPolicy(*label, FIT_POLICY_PARENT);
    layout.SetVerticalFitPolicy(*label, FIT_POLICY_FIXED);

    __pModelEditField = new EditField;
    __pModelEditField->Construct(Rectangle(0, 0, 150, 110), EDIT_FIELD_STYLE_NORMAL, INPUT_STYLE_FULLSCREEN);
    AddControl(*__pModelEditField);
    layout.SetHorizontalFitPolicy(*__pModelEditField, FIT_POLICY_PARENT);
    layout.SetVerticalFitPolicy(*__pModelEditField, FIT_POLICY_FIXED);

    label = new Label();
    label->Construct(Rectangle(0, 0, 48, 50), L"MNC:");
    AddControl(*label);
    layout.SetHorizontalFitPolicy(*label, FIT_POLICY_PARENT);
    layout.SetVerticalFitPolicy(*label, FIT_POLICY_FIXED);

    __pMncEditField = new EditField;
    __pMncEditField->Construct(Rectangle(0, 0, 150, 110), EDIT_FIELD_STYLE_NUMBER, INPUT_STYLE_FULLSCREEN);
    AddControl(*__pMncEditField);
    layout.SetHorizontalFitPolicy(*__pMncEditField, FIT_POLICY_PARENT);
    layout.SetVerticalFitPolicy(*__pMncEditField, FIT_POLICY_FIXED);
    __pMncEditField->SetText(L"01");

    label = new Label();
    label->Construct(Rectangle(0, 0, 48, 50), L"Developer flag:");
    AddControl(*label);
    layout.SetHorizontalFitPolicy(*label, FIT_POLICY_PARENT);
    layout.SetVerticalFitPolicy(*label, FIT_POLICY_FIXED);

    __pDevRadioGroup = new RadioGroup;
    __pDevRadioGroup->Construct();
    CheckButton * devbutton = new CheckButton;
    devbutton->Construct(Rectangle(0, 0, 150, 110), CHECK_BUTTON_STYLE_RADIO, BACKGROUND_STYLE_DEFAULT, false, "Developer mode, always success");
    devbutton->SetActionId(BuyConfigInfo::AlwaysSuccess, BuyConfigInfo::AlwaysSuccess);
    devbutton->AddActionEventListener(*this);
    AddControl(*devbutton);
    __pDevRadioGroup->Add(*devbutton);
    layout.SetHorizontalFitPolicy(*devbutton, FIT_POLICY_PARENT);
    layout.SetVerticalFitPolicy(*devbutton, FIT_POLICY_FIXED);
    AppLog("chkbtn %p", devbutton);

    __pDevRadioGroup->SetSelectedItem(*devbutton);

    devbutton = new CheckButton;
    devbutton->Construct(Rectangle(0, 0, 150, 110), CHECK_BUTTON_STYLE_RADIO, BACKGROUND_STYLE_DEFAULT, false, "Normal");
    devbutton->SetActionId(BuyConfigInfo::Normal, BuyConfigInfo::Normal);
    devbutton->AddActionEventListener(*this);
    AddControl(*devbutton);
    __pDevRadioGroup->Add(*devbutton);
    layout.SetHorizontalFitPolicy(*devbutton, FIT_POLICY_PARENT);
    layout.SetVerticalFitPolicy(*devbutton, FIT_POLICY_FIXED);
    AddControl(*__pDevRadioGroup);
    AppLog("chkbtn %p", devbutton);

    TableView * pTableView = new TableView();
    pTableView->Construct( Rectangle(0, 0, GetWidth(), 600), false, TABLE_VIEW_SCROLL_BAR_STYLE_NONE);
    AddControl(*pTableView);
    m_pTableView = pTableView;
    pTableView->SetItemProvider(this);
    pTableView->AddTableViewItemEventListener(*this);
    layout.SetHorizontalFitPolicy(*pTableView, FIT_POLICY_PARENT);
    layout.SetVerticalFitPolicy(*pTableView, FIT_POLICY_FIXED);

    GetFooter()->SetStyle(FOOTER_STYLE_BUTTON_TEXT);
    GetFooter()->AddActionEventListener(*this);

    __pMainListener = mainListener;

    BuyConfigInfo info;
    info.m_developerFlag = BuyConfigInfo::AlwaysSuccess;
    info.m_mcc = "000";
    info.m_mnc = "00";
    __pEngine = new BuyEngine(this, info);

    result r = __pEngine->RequestCountryList(0);
    if ( IsFailed(r) ) AppLog(GetErrorMessage(r));

    UpdateConfirmButtonState();

    return E_SUCCESS;
}

BuyConfigInfo ConfigForm::GetConfigInfo() const
{
    BuyConfigInfo info;
    info.m_developerFlag = BuyConfigInfo::Normal;

    if (__pDevRadioGroup->GetSelectedItem()->GetCheckedActionId() == BuyConfigInfo::AlwaysSuccess) {
        info.m_developerFlag = BuyConfigInfo::AlwaysSuccess;
    }
    info.m_mcc = m_mcc;
    info.m_mnc = __pMncEditField->GetText();
    info.m_model = __pModelEditField->GetText();
    AppLog("info.m_mcc: %S, info.m_mnc: %S, info.m_model: %S", info.m_mcc.GetPointer(), info.m_mnc.GetPointer(), info.m_model.GetPointer());

    return info;
}

void ConfigForm::OnCountryListReceived(
        int aTransactionId,
        StatusCode aStatusCode,
        const Tizen::Base::Collection::HashMap* countryList )
{
    if ( countryList ) {
        m_pCountryList = countryList->GetKeysN();
        m_pMccList = countryList->GetValuesN();

        if ( m_pCountryList && m_pMccList ) {
            m_pTableView->UpdateTableView();
        }
    }

    UpdateConfirmButtonState();
}

int ConfigForm::GetItemCount(void)
{
    if ( m_pCountryList )
        return m_pCountryList->GetCount();

    return 0;
}

Tizen::Ui::Controls::TableViewItem* ConfigForm::CreateItem(int itemIndex, int itemWidth)
{
    if ( !m_pCountryList || m_pCountryList->GetCount() <= itemIndex )
        return null;

    TableViewItem * pItem = new (std::nothrow) TableViewItem();
    pItem->Construct( Dimension(GetWidth(), ITEM_HEIGHT), TABLE_VIEW_ANNEX_STYLE_RADIO);
    pItem->SetBackgroundColor( Color( 0xE0, 0xE0, 0xE0 ) );

    Label * label = new Label();
    String * country = dynamic_cast<String*>(m_pCountryList->GetAt(itemIndex));
    label->Construct(Rectangle(0, 0, GetWidth(), ITEM_HEIGHT), *country);
    label->SetTextHorizontalAlignment( ALIGNMENT_LEFT );
    pItem->AddControl(*label);

    return pItem;
}

bool ConfigForm::DeleteItem(int itemIndex, Tizen::Ui::Controls::TableViewItem* pItem)
{
    return false;
}

void ConfigForm::UpdateItem(int itemIndex, Tizen::Ui::Controls::TableViewItem* pItem)
{
}

int ConfigForm::GetDefaultItemHeight(void)
{
    return ITEM_HEIGHT;
}

ConfigForm::ConfigForm()
    : m_pTableView(null)
    , m_pCountryList(null)
    , m_pMccList(null)
    , m_developerFlag(BuyConfigInfo::AlwaysSuccess)
{
}

void ConfigForm::OnTableViewItemStateChanged(
        Tizen::Ui::Controls::TableView& tableView,
        int itemIndex,
        Tizen::Ui::Controls::TableViewItem* pItem,
        Tizen::Ui::Controls::TableViewItemStatus status)
{
    for ( int i = 0; i < m_pTableView->GetItemCount(); ++i )
    {
        if ( i == itemIndex ) {
            if ( m_pTableView->IsItemChecked(itemIndex) ) {
                m_pTableView->SetItemChecked(itemIndex, true);
                AppLog("");
                if ( m_pMccList && m_pMccList->GetCount() > itemIndex ) {
                    String * pMcc = dynamic_cast<String*>(m_pMccList->GetAt(itemIndex));
                    if ( pMcc ) {
                        m_mcc = *pMcc;
                        AppLog("selected MCC: %ls", m_mcc.GetPointer());
                    }
                }
            }
            else {
                m_pTableView->SetItemChecked(itemIndex, false);
                m_mcc.Clear();
            }
        }
        else {
            m_pTableView->SetItemChecked(i, false);
        }
    }

    UpdateConfirmButtonState();
    m_pTableView->UpdateTableView();
}

void ConfigForm::OnActionPerformed(const Tizen::Ui::Control& source, int actionId)
{
    if ( actionId == 100 )
    {
        if ( __pMncEditField->GetText().IsEmpty()) {
            int messageBoxResult;
            MessageBox messageBox;
            messageBox.Construct( L"Info", L"MNC field cannot be empty.", MSGBOX_STYLE_OK ); // TODO Add localization
            messageBox.ShowAndWait(messageBoxResult);
            messageBox.SetShowState(false);
            messageBox.Invalidate(true);
        }
        else if ( m_mcc.IsEmpty() && m_developerFlag == BuyConfigInfo::AlwaysSuccess ) {
            int messageBoxResult;
            MessageBox messageBox;
            messageBox.Construct( L"Info", L"Country must be selected from list.", MSGBOX_STYLE_OK ); // TODO Add localization
            messageBox.ShowAndWait(messageBoxResult);
            messageBox.SetShowState(false);
            messageBox.Invalidate(true);
        }
        else {
            __pMainListener->OnActionPerformed(*this, actionId);
        }
    }
    else
    {
        Dimension size = m_pTableView->GetSize();
        if ( (BuyConfigInfo::DeveloperFlag)actionId == BuyConfigInfo::AlwaysSuccess ) {
            size.height = 600;
        }
        else {
            size.height = 0;
        }
        m_pTableView->SetSize(size);

        m_developerFlag = (BuyConfigInfo::DeveloperFlag)actionId;
        UpdateConfirmButtonState();
    }
}

ConfigForm::~ConfigForm()
{
    delete __pEngine;
    delete m_pCountryList;
    delete m_pMccList;
}

void ConfigForm::UpdateConfirmButtonState()
{
    bool enable = true;

    if ( __pMncEditField->GetText().IsEmpty() ) {
        enable = false;
    }
    else if ( m_developerFlag == BuyConfigInfo::AlwaysSuccess )
    {
        if ( m_mcc.IsEmpty() ) {
            enable = false;
        }
    }

    if ( enable && GetFooter()->GetItemCount() == 0) {
        FooterItem item;
        item.Construct(100);
        item.SetText(L"Confirm");
        GetFooter()->AddItem( item );
        GetFooter()->RequestRedraw(true);
    }
    else if (!enable) {
        GetFooter()->RemoveAllItems();
    }
}


