#ifndef _BUYPURCHASEDITEMINFORMATION_H_
#define _BUYPURCHASEDITEMINFORMATION_H_

#include <FBaseDateTime.h>

#include <buy/BuyItemInformation.h>
#include <buy/BuyItemList.h>

/**
 * This class contains the information of the item which was purchased.
 *
 */
class BuyPurchasedItemInformation: public BuyItemInformation
{
public:
    BuyPurchasedItemInformation();

    BuyPurchasedItemInformation(const BuyPurchasedItemInformation & aOther);

    BuyPurchasedItemInformation(const BuyItemInformation & aOther);

    ~BuyPurchasedItemInformation();

    BuyPurchasedItemInformation & operator=(const BuyPurchasedItemInformation & aOther);

    bool operator==(const BuyPurchasedItemInformation & aOther) const;

    bool operator!=(const BuyPurchasedItemInformation & aOther) const;

    /**
     * Sets the payment ID.
     *
     * @param paymentId
     *            The payment ID
     */
    void SetPaymentId(const Tizen::Base::String & aPaymentId);

    /**
     * Gets the payment ID.
     *
     * @return The payment ID
     */
    Tizen::Base::String GetPaymentId() const;

    /**
     * Sets the purchase date.
     *
     * @param purchaseDate
     *            The purchase date
     */
    void SetPurchaseDate(const Tizen::Base::DateTime & aPurchaseDate);

    /**
     * Gets the purchase date.
     *
     * @return The purchase date
     */
    Tizen::Base::DateTime GetPurchaseDate() const;

private:

    Tizen::Base::String paymentId;

    Tizen::Base::DateTime purchaseDate;

};

typedef BuyItemList<BuyPurchasedItemInformation> BuyPurchasedItemInformationList;

#endif // _BUYPURCHASEDITEMINFORMATION_H_
