#ifndef _BUYPURCHASETICKET_H_
#define _BUYPURCHASETICKET_H_

#include <buy/BuyItemInformation.h>

/**
 * This class contains the information of the transaction which is purchasing.
 *
 */
class BuyPurchaseTicket {

public:
    /**
     * Creates PurchaseTicket instance.
     */
    BuyPurchaseTicket();

    BuyPurchaseTicket(const BuyPurchaseTicket & aOther);

    ~BuyPurchaseTicket();

    BuyPurchaseTicket & operator=(const BuyPurchaseTicket & aOther);

    bool operator==(const BuyPurchaseTicket & aOther) const;

    bool operator!=(const BuyPurchaseTicket & aOther) const;

    /**
     * Gets the item ID which is purchasing.
     *
     * @return The item ID
     */
    Tizen::Base::String GetItemId() const;

    /**
     * Sets the item ID which is purchasing
     *
     * @param itemId
     *            The item ID
     */
    void SetItemId(const Tizen::Base::String & aItemId);

    /**
     * Gets the purchase ID which is purchasing.
     *
     * @return the purchase ID
     */
    Tizen::Base::String GetPurchaseId() const;

    /**
     * Sets the purchase ID which is purchasing.
     *
     * @param purchaseId
     *            the purchase ID
     */
    void SetPurchaseId(const Tizen::Base::String & aPurchaseId);

    /**
     * Gets the URL of the verification server.
     *
     * @return URL of the verification server
     */
    Tizen::Base::String GetVerifyUrl() const;

    /**
     * Sets the URL of the verification server.
     *
     * @param verifyUrl
     *            URL of the verification server
     */
    void SetVerifyUrl(const Tizen::Base::String & aVerifyUrl);

    /**
     * Gets the param1 value which to be used for purchase verification.
     *
     * @return The param1 value
     */
    Tizen::Base::String GetParam1() const;

    /**
     * Sets the param1 value which is to be used for purchase verification.
     *
     * @param param1
     *            The param1 value
     */
    void SetParam1(const Tizen::Base::String & aParam1);

    /**
     * Gets the param2 value which to be used for purchase verification.
     * 
     * @return The param2 value
     */
    Tizen::Base::String GetParam2() const;

    /**
     * Sets the param2 value which is to be used for purchase verification.
     * 
     * @param param2
     *            The param2 value
     */
    void SetParam2(const Tizen::Base::String & aParam2);

    /**
     * Gets the param3 value which to be used for purchase verification.
     * 
     * @return The param3 value
     */
    Tizen::Base::String GetParam3() const;

    /**
     * Sets the param3 value which is to be used for purchase verification.
     * 
     * @param param3
     *            The param3 value
     */
    void SetParam3(const Tizen::Base::String & aParam3);

private:

    Tizen::Base::String itemId;
    Tizen::Base::String purchaseId;
    Tizen::Base::String verifyUrl;
    Tizen::Base::String param1;
    Tizen::Base::String param2;
    Tizen::Base::String param3;

};

#endif // _BUYPURCHASETICKET_H_
