#ifndef _BUYITEMINFORMATION_H_
#define _BUYITEMINFORMATION_H_

#include <FBaseString.h>

#include <buy/BuyItemList.h>

/**
 * This class contains the item information.
 *
 */
class BuyItemInformation : public Tizen::Base::Object
{
public:
    /**
     * Creates BuyItemInformation instance.
     */
    BuyItemInformation();

    BuyItemInformation(const BuyItemInformation &aOther);

    BuyItemInformation & operator=(const BuyItemInformation &aOther);

    virtual ~BuyItemInformation();

    bool operator==(const BuyItemInformation &aOther) const;

    bool operator!=(const BuyItemInformation &aOther) const;

public:
    bool Equals(const BuyItemInformation &aOther) const;

    /**
     * Sets the item ID
     *
     * @param itemId
     *            The item ID
     */
    void SetItemId(const Tizen::Base::String & aItemId);

    /**
     * Gets the item ID.
     *
     * @return The item ID
     */
    Tizen::Base::String GetItemId() const;

    /**
     * Sets the item group ID
     *
     * @param aItemGroupId
     *            The item group ID
     */
    void SetItemGroupId(const Tizen::Base::String & aItemGroupId);

    /**
     * Gets the item group ID
     *
     * @return The item group ID
     */
    Tizen::Base::String GetItemGroupId() const;

    /**
     * Sets the item name.
     *
     * @param itemName
     *            The item name
     */
    void SetItemName(const Tizen::Base::String & aItemName);

    /**
     * Gets the item name.
     *
     * @return The item name
     */
    Tizen::Base::String GetItemName() const;

    /**
     * Sets the currency unit for the item price.
     *
     * @param currencyUnit
     *            The currency unit
     */
    void SetCurrencyUnit(const Tizen::Base::String & aCurrencyUnit);

    /**
     * Gets the currency unit for the item price.
     *
     * @return The currency unit
     */
    Tizen::Base::String GetCurrencyUnit() const;

    /**
     * Determines whether the currency unit precedes the price.
     *
     * @param currencyUnitPrecedes
     *            Precedes if <code>true</code>
     */
    void SetCurrencyUnitPrecedes(bool aCurrencyUnitPrecedes);

    /**
     * Tests if the currency unit precedes the price.
     *
     * @return <code>true</code> if precedes
     */
    bool GetCurrencyUnitPrecedes() const;

    /**
     * Determines whether the currency unit has a penny value.
     *
     * @param currencyUnitHasPenny
     *            Has penny value if <code>true</code>
     */
    void SetCurrencyUnitHasPenny(bool aCurrencyUnitHasPenny);

    /**
     * Tests if the currency unit has a penny value.
     *
     * @return <code>true</code> if has penny value
     */
    bool GetCurrencyUnitHasPenny() const;

    /**
     * Sets the item price.
     *
     * @param itemPrice
     *            The item price
     */
    void SetItemPrice(double aItemPrice);

    /**
     * Gets the item price.
     *
     * @return The item price
     */
    double GetItemPrice() const;

    /**
     * Gets formatted item price
     *
     * @return Formatted item price
     */
    Tizen::Base::String GetItemPriceFormatted(bool aWithCurrency = true) const;

    /**
     * Sets the download URL of the item.
     *
     * @param itemDownloadUrl
     *            The download URL
     */
    void SetItemDownloadUrl(const Tizen::Base::String & aItemDownloadUrl);

    /**
     * Gets the download URL of the item.
     *
     * @return The download URL
     */
    Tizen::Base::String GetItemDownloadUrl() const;

    /**
     * Sets the image URL of the item.
     *
     * @param itemImageUrl
     *            The image URL
     */
    void SetItemImageUrl(const Tizen::Base::String & aItemImageUrl);

    /**
     * Gets the image URL of the item.
     *
     * @return The image URL
     */
    Tizen::Base::String GetItemImageUrl() const;

    /**
     * Sets the description of the item.
     *
     * @param itemDescription
     *            The description
     */
    void SetItemDescription(const Tizen::Base::String & aItemDescription);

    /**
     * Gets the description of the item.
     *
     * @return The itemDescription
     */
    Tizen::Base::String GetItemDescription() const;

    /**
     * Sets the reserved1 value which is to be used for the user-defined value.
     *
     * @param reserved1
     *            The reserved1 value
     */
    void SetReserved1(const Tizen::Base::String & aReserved1);

    /**
     * Gets the reserved1 value which to be used for the user-defined value.
     *
     * @return The reserved1 value
     */
    Tizen::Base::String GetReserved1() const;

    /**
     * Sets the reserved2 value which is to be used for the user-defined value.
     *
     * @param reserved2
     *            The reserved2 value
     */
    void SetReserved2(const Tizen::Base::String & aReserved2);

    /**
     * Gets the reserved2 value which to be used for the user-defined value.
     *
     * @return The reserved2 value
     */
    Tizen::Base::String GetReserved2() const;

private:
    Tizen::Base::String itemId;
    Tizen::Base::String itemGroupId;
    Tizen::Base::String itemName;
    Tizen::Base::String currencyUnit;
    bool currencyUnitPrecedes;
    bool currencyUnitHasPenny;
    double itemPrice;
    Tizen::Base::String itemDownloadUrl;
    Tizen::Base::String itemImageUrl;
    Tizen::Base::String itemDescription;
    Tizen::Base::String reserved1;
    Tizen::Base::String reserved2;

};

typedef BuyItemList<BuyItemInformation> BuyItemInformationList;

#endif // _BUYITEMINFORMATION_H_
