#ifndef _BUY_APPCONTROL_SERIALIZATION_H_
#define _BUY_APPCONTROL_SERIALIZATION_H_

#include <buy/BuyItemInformation.h>
#include <buy/BuyPurchasedItemInformation.h>

class BuyPurchaseTicket;

namespace Tizen {
    namespace Base {
        namespace Collection {
            class IMap;
            class HashMap;
        } // namespace Collection
    } // namespace Base
} // namespace Tizen

namespace BuyAppControlSerialization {
    namespace ItemInformation {
        // Puts key BuyItemInformation data into HashMap map. Map should be constructed.
        // Created key/values must be deleted by caller
        result ToHashMap(const BuyItemInformation &info, Tizen::Base::Collection::HashMap *map);
    }

    namespace ItemInformationList {
        result FromIMap(const Tizen::Base::Collection::IMap &map, BuyItemInformationList *infoList);
    } // namespace ItemInformationList

    namespace PurchaseTicket {
        result FromIMap(const Tizen::Base::Collection::IMap &map, BuyPurchaseTicket *ticket);
    } // namespace PurchaseTicket

    namespace PurchasedItemInformation {
        result FromIMap(const Tizen::Base::Collection::IMap &map, BuyPurchasedItemInformation *info);
    } // namespace PurchasedItemInformation

    namespace PurchasedItemInformationList {
        result FromIMap(const Tizen::Base::Collection::IMap &map, BuyPurchasedItemInformationList *infoList);
    } // namespace PurchasedItemInformationList
} // namespace BuyAppControlSerialization

#endif // _BUY_APPCONTROL_SERIALIZATION_H_
