/*
 * DlgWait.h
 *
 *  Created on: Oct 4, 2012
 *      Author: sprc
 */

#ifndef ErrorPopup_H_
#define ErrorPopup_H_

#include <FUi.h>

/**
 * Simple popup for displaying error information.
 * Displays label with given information and dismiss button hiding this popup.
 */
class ErrorPopup: public Tizen::Ui::Controls::Popup, public Tizen::Ui::IActionEventListener, public Tizen::Ui::IOrientationEventListener
{
public:
    ErrorPopup();

    result Construct(const Tizen::Base::String& aInfo = L"");

    virtual ~ErrorPopup();

    /**
     * Set popup to invisible.
     */
    void PopupHide();
    /*
     * Make popup visible.
     */
    void PopupShow(const Tizen::Base::String& aInfo = L"");

public:
    // From Tizen::Ui::IOrientationEventListener
    void OnOrientationChanged(const Tizen::Ui::Control& source, Tizen::Ui::OrientationStatus orientationStatus);

protected:
    // from Tizen::Ui::IActionEventListener
    virtual void OnActionPerformed(const Tizen::Ui::Control& aSource, int aActionId);

protected:
    Tizen::Graphics::Dimension GetDimensionForOrientation() const;

private:
    // DO NOT OWN keep the reference to label for later changes of text
    Tizen::Ui::Controls::Label * __pLabel;
};

#endif /* ErrorPopup_H_ */
