#include <FUiGridLayout.h>
#include <FUiCtrlButton.h>
#include <FUiCtrlListView.h>
#include <FUiCtrlFooter.h>
#include <FAppUiApp.h>
#include <FGrpRectangle.h>

#include "ErrorPopup.h"

#include "ui/ItemListProvider.h"
#include "ui/MainForm.h"
#include "ui/SampleNativeSceneConsts.h"

#include "buy/BuyListener.h"
#include "buy/BuyEngine.h"

using namespace Tizen;
using namespace Ui;

using Controls::Button;
using Controls::ListView;
using Controls::Footer;
using Controls::FormStyle;
using Controls::FooterStyle;
using Tizen::Ui::GridLayout;
using Tizen::App::Application;
using Tizen::Graphics::Rectangle;
using Base::String;

#define BUTTON_DEFAULT_HEIGHT 74
#define BUTTON_MINIMAL_WIDTH 48

#define LIST_DEFAULT_WIDTH 48
#define LIST_DEFAULT_HEIGT 48

// initialize all pointer members with null
MainForm::MainForm() :
        Form(), __pListView(null), __transactionId(0), __pItemListProvider(null), __pEngine(null), __pPopup(null)
{
}

MainForm::~MainForm(void)
{
    delete __pEngine;
    delete __pItemListProvider;
    if (__pPopup)
    {
        delete __pPopup;
        __pPopup = null;
    }
}

result MainForm::Construct(const BuyConfigInfo & info)
{
    GridLayout mainLayout;
    mainLayout.Construct(3, 1);

    Form::Construct(mainLayout, Tizen::Ui::Controls::FORM_STYLE_NORMAL | Tizen::Ui::Controls::FORM_STYLE_INDICATOR | Tizen::Ui::Controls::FORM_STYLE_FOOTER);

    SetBackgroundColor(Tizen::Graphics::Color(0x93, 0xc5, 0x72));

    Button * pAvailableItems = new Button;
    pAvailableItems->Construct(Rectangle(0, 0, BUTTON_MINIMAL_WIDTH, BUTTON_DEFAULT_HEIGHT), L"Get Item List\n(\"getitemlist\")");
    AddControl(*pAvailableItems);
    mainLayout.SetPosition(*pAvailableItems, 0, 0, 1, 1);
    pAvailableItems->SetActionId(ButtonGetAvailableItems);
    pAvailableItems->AddActionEventListener(*this);

    Button * pPurchasedItems = new Button;
    pPurchasedItems->Construct(Rectangle(0, 0, BUTTON_MINIMAL_WIDTH, BUTTON_DEFAULT_HEIGHT), L"Get Purchased Item\n(\"getpurchaseditemlist\")");
    AddControl(*pPurchasedItems);
    mainLayout.SetPosition(*pPurchasedItems, 1, 0, 1, 1);
    pPurchasedItems->SetActionId(ButtonGetPurchasedItems);
    pPurchasedItems->AddActionEventListener(*this);

    // create UI list for displaying obtained items
    __pListView = new ListView();
    __pListView->Construct(
            Rectangle(0, 0, LIST_DEFAULT_WIDTH, LIST_DEFAULT_HEIGT), true, Tizen::Ui::Controls::SCROLL_STYLE_FIXED);
    __pListView->AddListViewItemEventListener(*this);
    __pListView->SetTextOfEmptyList(L"press button for items");
    AddControl(*__pListView);
    mainLayout.SetPosition(*__pListView, 2, 0, 1, 1);
    mainLayout.SetRowStretchable(2, true);
    mainLayout.SetAllColumnsStretchable(true);

    // create the footer for other user options
    Footer* pFooter = GetFooter();
    pFooter->SetStyle(Tizen::Ui::Controls::FOOTER_STYLE_BUTTON_TEXT);
    pFooter->SetBackButton();
    pFooter->AddActionEventListener(*this);
    SetFormBackEventListener(this);

    SetOrientation(Tizen::Ui::ORIENTATION_AUTOMATIC_FOUR_DIRECTION);
    AddOrientationEventListener(*this);

    __pItemListProvider = new ItemListProvider;
    __pItemListProvider->Construct(__pListView);

    __pEngine = new BuyEngine(this, info);

    if ( !__pEngine ) {
        return E_OUT_OF_MEMORY;
    }

    return E_SUCCESS;//retVal;
}

void MainForm::OnListViewItemStateChanged(Tizen::Ui::Controls::ListView & aListView, int aIndex, int aElementId,
        Tizen::Ui::Controls::ListItemStatus aStatus)
{
    // purchases will work only in available item list
    if ( __pItemListProvider->GetCurrentMode() == ItemListProvider::ItemInformation ) {
        BuyItemInformation dataItem;
        if ( ! IsFailed(__pItemListProvider->GetItemInformationAt(aIndex, dataItem)) ) {
            __pEngine->RequestPurchaseItem(__transactionId++, dataItem);
        }
    }
}

void MainForm::OnListViewItemSwept(Tizen::Ui::Controls::ListView& listView, int index, Tizen::Ui::Controls::SweepDirection direction)
{
}

void MainForm::OnListViewContextItemStateChanged(Tizen::Ui::Controls::ListView& listView, int index, int elementId, Tizen::Ui::Controls::ListContextItemStatus status)
{
}

void MainForm::OnFormBackRequested(Tizen::Ui::Controls::Form& source)
{
    Application::GetInstance()->Terminate();
}

void MainForm::OnItemInformationListReceived(int aTransactionId, BuyListener::StatusCode aStatusCode, const BuyItemInformationList& aItemInformationList)
{
    if (__pItemListProvider) {
        // callback after requesting items list - when got error do something like displaying error dialog
        if (aStatusCode == BuyListener::Succeed) {
            __pItemListProvider->SetItemInformationList(aItemInformationList);
        }
        else if(aStatusCode != BuyListener::Cancel) {
            ShowErrorPopup( BuyListener::GetErrorString(aStatusCode) );
        }
    }
}

void MainForm::OnPurchasedItemInformationListReceived(int aTransactionId, BuyListener::StatusCode aStatusCode, const BuyPurchasedItemInformationList& aPurchasedItemInformationList)
{
    if (__pItemListProvider) {
        // callback after requesting items list - when got error do something like displaying error dialog
        if (aStatusCode == BuyListener::Succeed) {
            __pItemListProvider->SetPurchasedItemInformationList(aPurchasedItemInformationList);
        }
        else if(aStatusCode != BuyListener::Cancel) {
            ShowErrorPopup( BuyListener::GetErrorString(aStatusCode) );
        }
    }
}

void MainForm::OnPurchaseItemInitialized(int aTransactionId, BuyListener::StatusCode aStatusCode, const BuyPurchaseTicket& aPurchaseTicket)
{
    if(aStatusCode != BuyListener::Cancel && aStatusCode != BuyListener::Succeed) {
        ShowErrorPopup( BuyListener::GetErrorString(aStatusCode) );
    }
}

void MainForm::OnPurchaseItemFinished(int aTransactionId, BuyListener::StatusCode aStatusCode, const BuyPurchasedItemInformation& aPurchasedItemInformation)
{
    if(aStatusCode != BuyListener::Cancel && aStatusCode != BuyListener::Succeed) {
        ShowErrorPopup( BuyListener::GetErrorString(aStatusCode) );
    }
}

void MainForm::OnActionPerformed(const Tizen::Ui::Control& aSource, int aActionId)
{
    switch (aActionId)
    {
    case MainForm::ButtonGetAvailableItems: {
        AppLog("MainForm::ButtonGetAvailableItems");
        // clear list
        __pItemListProvider->ClearAll();
        // and request download of the specified available item RANGE
        __pEngine->RequestItemInformationList(__transactionId++, 1, 15);
        break;
    }

    case MainForm::ButtonGetPurchasedItems:
        AppLog("MainForm::ButtonGetPurchasedItems");
        // clear list
        __pItemListProvider->ClearAll();
        // and request download of the specified available item RANGE
        __pEngine->RequestPurchasedItemInformationList(__transactionId++, 1, 15);
        break;
    }
}

void MainForm::OnOrientationChanged(const Tizen::Ui::Control& source,
        Tizen::Ui::OrientationStatus orientationStatus)
{
    __pListView->UpdateList();
}

void MainForm::OnSceneActivatedN(const Tizen::Ui::Scenes::SceneId& previousSceneId,
        const Tizen::Ui::Scenes::SceneId& currentSceneId, Tizen::Base::Collection::IList* pArgs)
{
    AppLog("OnSceneActivatedN");
}

void MainForm::OnSceneDeactivated(const Tizen::Ui::Scenes::SceneId& currentSceneId,
        const Tizen::Ui::Scenes::SceneId& nextSceneId)
{
    AppLog("OnSceneDeactivated");
}

void MainForm::ShowErrorPopup(const Tizen::Base::String &aText)
{
    if ( __pPopup == null ) {
        __pPopup = new ErrorPopup();
        __pPopup->Construct();
    }

    __pPopup->PopupShow(aText);
}
