#include "buy/BuyPurchaseTicket.h"

using namespace Tizen::Base;

BuyPurchaseTicket::BuyPurchaseTicket()
{
}

BuyPurchaseTicket::BuyPurchaseTicket(const BuyPurchaseTicket & aOther)
    : itemId(aOther.itemId)
    , purchaseId(aOther.purchaseId)
    , verifyUrl(aOther.verifyUrl)
    , param1(aOther.param1)
    , param2(aOther.param2)
    , param3(aOther.param3)
{
}

BuyPurchaseTicket::~BuyPurchaseTicket()
{
}

BuyPurchaseTicket & BuyPurchaseTicket::operator=(const BuyPurchaseTicket & aOther)
{
    if (aOther != *this) {
        itemId = aOther.itemId;
        purchaseId = aOther.purchaseId;
        verifyUrl = aOther.verifyUrl;
        param1 = aOther.param1;
        param2 = aOther.param2;
        param3 = aOther.param3;
    }

    return *this;
}

String BuyPurchaseTicket::GetItemId() const
{
    return itemId;
}

void BuyPurchaseTicket::SetItemId(const String & aItemId)
{
    itemId = aItemId;
}

String BuyPurchaseTicket::GetPurchaseId() const
{
    return purchaseId;
}

void BuyPurchaseTicket::SetPurchaseId(const String & aPurchaseId)
{
    purchaseId = aPurchaseId;
}

String BuyPurchaseTicket::GetVerifyUrl() const
{
    return verifyUrl;
}

void BuyPurchaseTicket::SetVerifyUrl(const String & aVerifyUrl)
{
    verifyUrl = aVerifyUrl;
}

String BuyPurchaseTicket::BuyPurchaseTicket::GetParam1() const
{
    return param1;
}

void BuyPurchaseTicket::SetParam1(const String & aParam1)
{
    param1 = aParam1;
}

String BuyPurchaseTicket::GetParam2() const
{
    return param2;
}

void BuyPurchaseTicket::SetParam2(const String & aParam2)
{
    param2 = aParam2;
}

String BuyPurchaseTicket::GetParam3() const
{
    return param3;
}

bool BuyPurchaseTicket::operator ==(const BuyPurchaseTicket & aOther) const
{
    bool retval = true;

    retval = itemId == aOther.itemId
            && purchaseId == aOther.purchaseId
            && verifyUrl == aOther.verifyUrl
            && param1 == aOther.param1
            && param2 == aOther.param2
            && param3 == aOther.param3;

    return retval;
}

bool BuyPurchaseTicket::operator !=(const BuyPurchaseTicket & aOther) const
{
    return ! operator==(aOther);
}

void BuyPurchaseTicket::SetParam3(const String & aParam3)
{
    param3 = aParam3;
}
