/*
 * BuyEngine.cpp
 *
 *  Created on: May 17, 2013
 *      Author: sprc
 */
#include "buy/BuyEngine.h"
#include "buy/BuyUtils.h"

#include "buy/BuyAppControlRequest.h"
#include "buy/BuyAppControlTypes.h"
#include "buy/BuyPurchasedItemInformation.h"
#include "buy/BuyAppControlSerialization.h"
#include "buy/BuyPurchaseTicket.h"
#include "buy/BuyListener.h"

#include <FBaseCol.h>

using namespace Tizen;
using namespace App;
using namespace Base;
using namespace Base::Collection;
using namespace BuyAppControlSerialization;

// our sample group id
#define GROUP_ID L"100000001455"
//#define GROUP_ID L"100000002501"

BuyEngine::BuyEngine(BuyListener * aListener, const BuyConfigInfo & info) : __configInfo(info), __pListener(aListener)
{
}

BuyEngine::~BuyEngine()
{
}

void BuyEngine::OnAppControlCompleteResponseReceived(
        const AppId& appId,
        const String& operationId,
        AppCtrlResult appControlResult,
        const Collection::IMap* pExtraData )
{
    AppLog("%s: appControlResult: %d", __FUNCTION__, appControlResult);

    String method;
    // TODO logthis removethis
    /*
    IList * keys = pExtraData->GetKeysN();
    IList * vlaues = pExtraData->GetValuesN();
    if ( !keys || !vlaues ) {
        AppLog("keys %p", keys);
        AppLog("vlaues %p", vlaues);
    }
    else
    {
        for( int i = 0; i < keys->GetCount(); ++i )
        {
            const String * key = dynamic_cast<String*>(keys->GetAt(i));
            const String * value = dynamic_cast<String*>(vlaues->GetAt(i));
            if ( key && value ) {
                AppLog("key: %ls value: %ls", key->GetPointer(), value->GetPointer());
            }
            else {
                AppLog("key %p", key);
                AppLog("value %p", value);
            }
        }
    }
*/
    result res = BuyHashMapUtils::GetStringValue(pExtraData, BUY_APPCTRL_KEY_METHOD, method);

    if (res == E_SUCCESS) {
        int statusTemp;
        BuyHashMapUtils::GetIntegerValue(pExtraData, BUY_APPCTRL_KEY_RESULT_CODE, statusTemp);
        BuyListener::StatusCode status = BuyListener::Unknown;
    	AppLog("statusTemp: %d, method: %S", statusTemp, method.GetPointer());

        if ( res == E_SUCCESS ) {
            switch(statusTemp) {
            case BuyListener::Succeed:
            case BuyListener::Cancel:
            case BuyListener::NetworkError:
            case BuyListener::ProcessError:
            case BuyListener::ServiceUnavailable:
            case BuyListener::ItemGroupIdNotFound:
            case BuyListener::PaymentIdNotFound:
            case BuyListener::ItemIdNotFound:
                status = (BuyListener::StatusCode)statusTemp;
                break;
            }
        }

        int transId;
        res = BuyHashMapUtils::GetIntegerValue(pExtraData, BUY_APPCTRL_KEY_TRANSACTION_ID, transId);

        if (IsFailed(res)) {
            transId =  -1;
        }

        if (method == BUY_METHOD_PURCHASE_FINISHED) {
            BuyPurchasedItemInformation info;

            res = PurchasedItemInformation::FromIMap(*pExtraData, &info);
            if (IsFailed(res)) {
                status = BuyListener::ProcessError;
            }

            __pListener->OnPurchaseItemFinished(transId, status, info);
        } else if (method == BUY_METHOD_PURCHASE_INITIALIZED) {
            BuyPurchaseTicket ticket;
            res = PurchaseTicket::FromIMap(*pExtraData, &ticket);
            if (IsFailed(res)) {
                status = BuyListener::ProcessError;
            }

            if (status == BuyListener::Succeed) {
                // Only if this call develuscceeded we will get purchaseFinished
                // make new request to handle purchaseFinished
                BuyAppControlRequest req;
                result res = req.Construct(BUY_APPCTRL_OP_PURCHASE, __configInfo);
                if (res == E_SUCCESS) {
                    res = req.Add(BUY_APPCTRL_KEY_TRANSACTION_ID, transId);
                    res = res | req.Add(BUY_APPCTRL_KEY_PURCHASE_RESUME, 1);

                    if (res == E_SUCCESS) {
                        res = req.Send(this);
                    }
                }
            }

            AppLog(GetErrorMessage(res));
            __pListener->OnPurchaseItemInitialized(transId, status, ticket);

            if (IsFailed(res)) {
                // Client does not have new request id so we won't receive response
                __pListener->OnPurchaseItemFinished(transId, BuyListener::ProcessError, BuyPurchasedItemInformation());
            }
        } else if (method == BUY_METHOD_INFORMATION_LIST_RECEIVED) {
            BuyItemInformationList list;
            res = ItemInformationList::FromIMap(*pExtraData, &list);
            if (IsFailed(res)) {
                status = BuyListener::ProcessError;
            }

            __pListener->OnItemInformationListReceived(transId, status, list);
        }
        else if (method == BUY_METHOD_PURCHASED_LIST_RECEIVED)
        {
            BuyPurchasedItemInformationList list;
            res = PurchasedItemInformationList::FromIMap(*pExtraData, &list);
            if (IsFailed(res)) {
                status = BuyListener::ProcessError;
            }

            __pListener->OnPurchasedItemInformationListReceived(transId, status, list);
        }
        else if ( method == IAP_METHOD_COUNTRY_LIST_RECEIVED)
        {
            HashMap * pCountryMap = new HashMap();
            pCountryMap->Construct();

            int startNumber;
            int endNumber;
            result r = BuyHashMapUtils::GetIntegerValue(pExtraData, BUY_APPCTRL_KEY_START_NUMBER, startNumber);
            TryLogReturn( !IsFailed(r), , GetErrorMessage(r) );
            r = BuyHashMapUtils::GetIntegerValue(pExtraData, BUY_APPCTRL_KEY_END_NUMBER, endNumber);
            TryLogReturn( !IsFailed(r), , GetErrorMessage(r) );

            for ( int i = startNumber; i <= endNumber; ++i )
            {
                String countryKey;
                countryKey.Append(i);
                const String * pCountryValue;
                countryKey.Append(L"_countryName");
                pCountryValue = dynamic_cast<const String*>(pExtraData->GetValue(countryKey));
                String mccKey;
                mccKey.Append(i);
                const String * pMccValue;
                mccKey.Append(L"_mcc");
                pMccValue = dynamic_cast<const String*>(pExtraData->GetValue(mccKey));

                if ( pCountryValue && pMccValue )
                {
                    pCountryMap->Add( new String(*pCountryValue), new String(*pMccValue) );
                }
                else
                {
                    AppLog("Error failed to get country(%p) or mcc(%p)", pCountryValue, pMccValue);
                }
            }
            __pListener->OnCountryListReceived(transId, status, pCountryMap);
        }
        // Extract transactionId and
    } else {
        AppLogException("Got AppControlr response but no method included!");
    }
}

result BuyEngine::RequestPurchaseItem(int aTransactionId, const BuyItemInformation & aItem)
{
    BuyAppControlRequest req;
    result res = req.Construct(BUY_APPCTRL_OP_PURCHASE, __configInfo);
    TryReturn(res == E_SUCCESS, res, GetErrorMessage(res));
    res = req.Add(BUY_APPCTRL_KEY_ITEM_ID, aItem.GetItemId());
    TryReturn(res == E_SUCCESS, res, GetErrorMessage(res));
    res = req.Add(BUY_APPCTRL_KEY_ITEM_GROUP_ID, aItem.GetItemGroupId());
    TryReturn(res == E_SUCCESS, res, GetErrorMessage(res));
    res = req.Add(BUY_APPCTRL_KEY_TRANSACTION_ID, aTransactionId);
    TryReturn(res == E_SUCCESS, res, GetErrorMessage(res));
    return req.Send(this);
}

result BuyEngine::RequestItemInformationList(int aTransactionId, int aStartNum, int aEndNum)
{
    BuyAppControlRequest req;
    result res = req.Construct(BUY_APPCTRL_OP_GET_ITEM_LIST, __configInfo);
    TryReturn(res == E_SUCCESS, res, GetErrorMessage(res));
    res = req.Add(BUY_APPCTRL_KEY_TRANSACTION_ID, aTransactionId);
    TryReturn(res == E_SUCCESS, res, GetErrorMessage(res));
    res = req.Add(BUY_APPCTRL_KEY_START_NUMBER, aStartNum);
    TryReturn(res == E_SUCCESS, res, GetErrorMessage(res));
    res = req.Add(BUY_APPCTRL_KEY_END_NUMBER, aEndNum);
    TryReturn(res == E_SUCCESS, res, GetErrorMessage(res));
    res = req.Add(BUY_APPCTRL_KEY_ITEM_GROUP_ID, GROUP_ID);
    TryReturn(res == E_SUCCESS, res, GetErrorMessage(res));
    return req.Send(this);
}

result BuyEngine::RequestPurchasedItemInformationList(int aTransactionId, int aStartNum, int aEndNum)
{
    BuyAppControlRequest req;
    result res = req.Construct(BUY_APPCTRL_OP_GET_PURCHASED_ITEM_LIST, __configInfo);
    TryReturn(res == E_SUCCESS, res, GetErrorMessage(res));
    res = req.Add(BUY_APPCTRL_KEY_TRANSACTION_ID, aTransactionId);
    TryReturn(res == E_SUCCESS, res, GetErrorMessage(res));
    res = req.Add(BUY_APPCTRL_KEY_START_NUMBER, aStartNum);
    TryReturn(res == E_SUCCESS, res, GetErrorMessage(res));
    res = req.Add(BUY_APPCTRL_KEY_END_NUMBER, aEndNum);
    TryReturn(res == E_SUCCESS, res, GetErrorMessage(res));
    res = req.Add(BUY_APPCTRL_KEY_ITEM_GROUP_ID, GROUP_ID);
    TryReturn(res == E_SUCCESS, res, GetErrorMessage(res));
    return req.Send(this);
}

result BuyEngine::RequestCountryList(int aTransactionId)
{
    BuyAppControlRequest req;
    result res = req.Construct(BUY_APPCTRL_OP_GET_COUNTRY_LIST);
    TryReturn(res == E_SUCCESS, res, GetErrorMessage(res));
    res = req.Add(BUY_APPCTRL_KEY_TRANSACTION_ID, aTransactionId);
    TryReturn(res == E_SUCCESS, res, GetErrorMessage(res));
    return req.Send(this);
}

