/*
 * DlgWait.cpp
 *
 *  Created on: Oct 4, 2012
 *      Author: sprc
 */
#include <FApp.h>

#include "ErrorPopup.h"

using namespace Tizen::Base;
using namespace Tizen::Base::Collection;
using namespace Tizen::Graphics;
using namespace Tizen::Ui;
using namespace Tizen::Ui::Controls;

const int KRowH = 100;

ErrorPopup::ErrorPopup() //
    : Popup() //
    , __pLabel(null) //
{
}

result ErrorPopup::Construct(const Tizen::Base::String& aInfo)
{
    VerticalBoxLayout layout;
    layout.Construct(VERTICAL_DIRECTION_DOWNWARD);

    Frame * pAppFrame = Tizen::App::Application::GetInstance()->GetAppFrame()->GetFrame();

    Popup::Construct(layout, false, GetDimensionForOrientation());

    String sLabel(aInfo);
    if (sLabel.IsEmpty()) {
        sLabel.Append(L"Network error occurred");
    }

    Label * pLabel = new Label();
    pLabel->Construct(Rectangle(0, 0, 450, 100), sLabel);
    pLabel->SetTextHorizontalAlignment(ALIGNMENT_CENTER);
    AddControl(*pLabel);
    __pLabel = pLabel;

    layout.SetHorizontalFitPolicy(*pLabel, FIT_POLICY_CONTENT);
    layout.SetHorizontalAlignment(*pLabel, LAYOUT_HORIZONTAL_ALIGN_CENTER);
    layout.SetWeight(*pLabel, 2.0f);

    Button * pButton = new Button();
    pButton->Construct(Rectangle(0, 0, GetWidth() - 40, 100), L"OK"); // TODO: Add localization
    pButton->SetActionId(1);
    pButton->AddActionEventListener(*this);
    AddControl(*pButton);

    layout.SetVerticalFitPolicy(*pButton, FIT_POLICY_FIXED);
    layout.SetHorizontalAlignment(*pButton, LAYOUT_HORIZONTAL_ALIGN_CENTER);

    Label *pBottomMarginLabel = new Label();
    pBottomMarginLabel->Construct( Rectangle(0, 0, 450, 20), L"");
    AddControl(*pBottomMarginLabel);
    layout.SetHorizontalFitPolicy(*pBottomMarginLabel, FIT_POLICY_CONTENT);
    layout.SetVerticalFitPolicy(*pBottomMarginLabel, FIT_POLICY_FIXED);
    layout.SetHorizontalAlignment(*pBottomMarginLabel, LAYOUT_HORIZONTAL_ALIGN_CENTER);

    pAppFrame->AddOrientationEventListener(*this);

    return E_SUCCESS;
}

ErrorPopup::~ErrorPopup()
{
    PopupHide();
}

void ErrorPopup::PopupHide()
{
    SetShowState(false);
    Invalidate(true);
}

void ErrorPopup::PopupShow(const Tizen::Base::String& aInfo)
{
    if (!aInfo.IsEmpty()) {
        __pLabel->SetText(aInfo);
    }
    SetShowState(true);
    Show();
}

void ErrorPopup::OnOrientationChanged(const Tizen::Ui::Control& source, Tizen::Ui::OrientationStatus orientationStatus)
{
    Layout * lay = null;
    switch(orientationStatus)
    {
    case ORIENTATION_STATUS_PORTRAIT:
    case ORIENTATION_STATUS_PORTRAIT_REVERSE:
        lay = GetPortraitLayoutN();
        break;

    case ORIENTATION_STATUS_LANDSCAPE:
    case ORIENTATION_STATUS_LANDSCAPE_REVERSE:
        lay = GetLandscapeLayoutN();
        break;

    case ORIENTATION_STATUS_NONE:
        break;
    }

    if ( lay ) {
        lay->Update();
        delete lay;
    }

    Invalidate(true);
}

void ErrorPopup::OnActionPerformed(const Tizen::Ui::Control& aSource, int aActionId)
{
	PopupHide();
}

Tizen::Graphics::Dimension ErrorPopup::GetDimensionForOrientation() const
{
    Dimension retval;
    Frame * pAppFrame = Tizen::App::Application::GetInstance()->GetAppFrame()->GetFrame();
    Rectangle screenRect = pAppFrame->GetBounds();

    switch(pAppFrame->GetOrientationStatus())
    {
    case ORIENTATION_STATUS_LANDSCAPE:
    case ORIENTATION_STATUS_LANDSCAPE_REVERSE:
        retval.width = screenRect.height - screenRect.height / 6;
        retval.height = screenRect.width / 4;
        break;

    case ORIENTATION_STATUS_PORTRAIT:
    case ORIENTATION_STATUS_PORTRAIT_REVERSE:
        retval.width = screenRect.width - screenRect.width / 6;
        retval.height = screenRect.height / 4;
        break;

    case ORIENTATION_STATUS_NONE:
        break;
    }

    return retval;
}

