#ifndef _MainForm_H_
#define _MainForm_H_

#include <FBaseString.h>
#include <FUiCtrlForm.h>
#include <FUiIActionEventListener.h>
#include <FUiIOrientationEventListener.h>
#include <FUiScenesISceneEventListener.h>

#include <FUiCtrlIListViewItemEventListener.h>
#include <FUiCtrlIFormBackEventListener.h>

#include "buy/BuyEngine.h"
#include "buy/BuyListener.h"

class ErrorPopup;
class Listener;
class ItemListProvider;
class BuyEngine;

/**
 * Main form of test application.
 *  - displaying list of available items; obtained item can be latter bought by pressing the purchase button
 *  - displaying list of purchased items
 *  - starting simple purchase process
 */
class MainForm:
    public Tizen::Ui::Controls::Form,
    public BuyListener,
    public Tizen::Ui::IActionEventListener,
    public Tizen::Ui::Controls::IListViewItemEventListener,
    public Tizen::Ui::Controls::IFormBackEventListener,
    public Tizen::Ui::IOrientationEventListener,
    public Tizen::Ui::Scenes::ISceneEventListener //
{
protected:
    enum Buttons
    {
        ButtonGetAvailableItems = 301,
        ButtonGetPurchasedItems
    };

public:
    MainForm();

    virtual ~MainForm(void);

public:
    virtual result Construct(const BuyConfigInfo & info);

public:
    // from BuyListener
    virtual void OnItemInformationListReceived(int aTransactionId, BuyListener::StatusCode aStatusCode,
            const BuyItemInformationList & aItemInformationList);

    virtual void OnPurchasedItemInformationListReceived(int aTransactionId, BuyListener::StatusCode aStatusCode,
            const BuyPurchasedItemInformationList & aPurchasedItemInformationList);

    virtual void OnPurchaseItemInitialized(int aTransactionId, BuyListener::StatusCode aStatusCode,
            const BuyPurchaseTicket & aPurchaseTicket);

    virtual void OnPurchaseItemFinished(int aTransactionId, BuyListener::StatusCode aStatusCode,
            const BuyPurchasedItemInformation & aPurchasedItemInformation);

public:
    // From Tizen::Ui::IActionEventListener
    virtual void OnActionPerformed(const Tizen::Ui::Control& aSource, int aActionId);

public:
    // From Tizen::Ui::Controls::IListViewItemEventListener
    virtual void OnListViewItemStateChanged(Tizen::Ui::Controls::ListView & listView, int index, int elementId,
            Tizen::Ui::Controls::ListItemStatus status);

    virtual void OnListViewItemSwept(Tizen::Ui::Controls::ListView& listView, int index, Tizen::Ui::Controls::SweepDirection direction);

    virtual void OnListViewContextItemStateChanged(Tizen::Ui::Controls::ListView& listView, int index, int elementId, Tizen::Ui::Controls::ListContextItemStatus status);

public:
    // From Tizen::Ui::Controls::IFormBackEventListener
    virtual void OnFormBackRequested(Tizen::Ui::Controls::Form& source);

public:
    // From Tizen::Ui::IOrientationEventListener
    void OnOrientationChanged(const Tizen::Ui::Control& source, Tizen::Ui::OrientationStatus orientationStatus);

protected:
    // from Ui::Scenes::ISceneEventListener
    virtual void OnSceneActivatedN(const Tizen::Ui::Scenes::SceneId& previousSceneId,
            const Tizen::Ui::Scenes::SceneId& currentSceneId, Tizen::Base::Collection::IList* pArgs);

    virtual void OnSceneDeactivated(const Tizen::Ui::Scenes::SceneId& currentSceneId, const Tizen::Ui::Scenes::SceneId& nextSceneId);

private:
    void ShowErrorPopup(const Tizen::Base::String &aText = Tizen::Base::String());

private:
    // DO NOT OWN UI list displaying available items (__listData) obtained from the IAP library.
    Tizen::Ui::Controls::ListView * __pListView;

    // unique IDs for the transactions (we simply increase it with every new request).
    int __transactionId;

    // ListView item provider for Form view
    ItemListProvider * __pItemListProvider;

    // Engine instance
    BuyEngine * __pEngine;

    ErrorPopup * __pPopup;

};

#endif	//_MainForm_H_
