#ifndef _BUY_APP_CONTROL_REQUEST_H_
#define _BUY_APP_CONTROL_REQUEST_H_

#include <FBaseString.h>
#include <FBaseDataType.h>

#include "buy/BuyEngine.h"

class BuyItemInformation;

namespace Tizen {
    namespace Base {
        namespace Collection {
            class HashMap;
        } // namespace Collection
    } // namespace Base

    namespace App {
        class IAppControlResponseListener;
    } // namespace App
} // namespace Tizen

class BuyAppControlRequest
{
public:
    BuyAppControlRequest();

    ~BuyAppControlRequest();

    result Construct(const Tizen::Base::String &operation, int capacity = 16);
    result Construct(const Tizen::Base::String &operation, BuyConfigInfo info, int capacity = 16);

    result Add(const wchar_t *key, const wchar_t *value);
    result Add(const wchar_t *key, int value);
    result Add(const wchar_t *key, const Tizen::Base::String &value);

    result Send(Tizen::App::IAppControlResponseListener * aListener);

private:
    Tizen::Base::String m_sOperation;

    Tizen::Base::Collection::HashMap *m_pHashMap;

};

#endif // _BUY_APP_CONTROL_REQUEST_H_
