﻿/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Xamarin.Forms;

namespace VolumeController
{
    //fake enum class


    public partial class FirstPage : ContentPage
    {

        enum AudioVolumeType
        {
            Alarm = 0,
            Notification = 1,
            System = 2,
            Ringtone = 3,
            Media = 4,
            Call = 5,
            None = 6,
            Voip = 7,
            Voice = 8
        }

        public FirstPage()
        {

            InitializeComponent();

        }

        private Dictionary<AudioVolumeType, Label> controllerLabelDictionary;
        private Dictionary<AudioVolumeType, Slider> controllerSliderDictionary;

        private bool _contentLoaded;
        void InitializeComponent()
        {
            if (_contentLoaded)
            {
                return;
            }
            _contentLoaded = true;

            // UI Logic Development
            #region UI Logic

            /* this.Content = new ScrollView()
             {
                 HorizontalOptions = LayoutOptions.FillAndExpand,
                 Orientation = ScrollOrientation.Vertical,
                 Content = CreateAllControllers()
             };*/

            this.Content = CreateAllControllers();
            #endregion
        }

        private StackLayout CreateAllControllers()
        {
            controllerLabelDictionary = new Dictionary<AudioVolumeType, Label>();
            controllerSliderDictionary = new Dictionary<AudioVolumeType, Slider>();

            StackLayout controllers = new StackLayout();
            controllers.HorizontalOptions = LayoutOptions.FillAndExpand;
            controllers.Padding = new Thickness(0,30,0,0);

            foreach (AudioVolumeType type in Enum.GetValues(typeof(AudioVolumeType)))
                {
                    if (type != AudioVolumeType.None && type != AudioVolumeType.Voip && type != AudioVolumeType.Voice)
                    {
                        controllers.Children.Add(CreateController(type));
                    }
                }
            return controllers;
        }

        private StackLayout CreateController(AudioVolumeType type)
        {
            Label soundType = new Label();
            soundType.Text = type.ToString();
            soundType.FontSize = 50.0;
            soundType.TextColor = new Color(0,0,0);
            soundType.HorizontalOptions = LayoutOptions.StartAndExpand;

               Label soundLevel = new Label();
               soundLevel.Text = type.ToString();
               //fake value
               soundLevel.Text = AudioVolumeType.Alarm.ToString();
               soundLevel.FontSize = 50.0;
               soundLevel.HorizontalOptions = LayoutOptions.EndAndExpand;
               soundLevel.TextColor = new Color(0, 0, 0);
               soundLevel.LineBreakMode = LineBreakMode.NoWrap;
               controllerLabelDictionary.Add(type, soundLevel);

               Layout typeAndLevel = new StackLayout()
               {
                   //Orientation = Orientations.Horizontal,
                   HorizontalOptions = LayoutOptions.FillAndExpand,
                   Padding = new Thickness(30, 0, 30, 30),
                   Children =
                   {
                       soundType,
                       soundLevel
                   }
               };

               Slider slider = new Slider();
               slider.HorizontalOptions = LayoutOptions.FillAndExpand;
               slider.Minimum = 0;
            // slider.Maximum = AudioManager.VolumeController.MaxLevel[type];
            slider.Maximum = 100;
            //slider.Value = AudioManager.VolumeController.Level[type];
            slider.Value = 50;
            //fake value
             switch (type)
             {
                 case AudioVolumeType.System:
                     slider.ValueChanged += SystemSliderDragged;
                     break;
                 case AudioVolumeType.Notification:
                     slider.ValueChanged += NotificationSliderDragged;
                     break;
                 case AudioVolumeType.Alarm:
                     slider.ValueChanged += AlarmSliderDragged;
                     break;
                 case AudioVolumeType.Ringtone:
                     slider.ValueChanged += RingtoneSliderDragged;
                     break;
                 case AudioVolumeType.Media:
                     slider.ValueChanged += MediaSliderDragged;
                     break;
                 case AudioVolumeType.Call:
                     slider.ValueChanged += CallSliderDragged;
                     break;
                 default:
                     break;
             }
             controllerSliderDictionary.Add(type, slider);

            StackLayout controller = new StackLayout();
            controller.HorizontalOptions = LayoutOptions.FillAndExpand;
            controller.VerticalOptions = LayoutOptions.StartAndExpand;
            controller.Children.Add(typeAndLevel);
            controller.Children.Add(slider);

            return controller;
        }

        private void SystemSliderDragged(object sender, EventArgs e)
        {
            UpdateVolumeAndLabelFromDrag(AudioVolumeType.System, sender);
        }
        private void NotificationSliderDragged(object sender, EventArgs e)
        {
            UpdateVolumeAndLabelFromDrag(AudioVolumeType.Notification, sender);
        }
        private void AlarmSliderDragged(object sender, EventArgs e)
        {
            UpdateVolumeAndLabelFromDrag(AudioVolumeType.Alarm, sender);
        }
        private void RingtoneSliderDragged(object sender, EventArgs e)
        {
            UpdateVolumeAndLabelFromDrag(AudioVolumeType.Ringtone, sender);
        }
        private void MediaSliderDragged(object sender, EventArgs e)
        {
            UpdateVolumeAndLabelFromDrag(AudioVolumeType.Media, sender);
        }
        private void CallSliderDragged(object sender, EventArgs e)
        {
            UpdateVolumeAndLabelFromDrag(AudioVolumeType.Call, sender);
        }
        private void UpdateVolumeAndLabelFromDrag(AudioVolumeType type, object sliderObject)
        {
            Slider slider = (Slider)sliderObject;
            slider.Value = Math.Round(slider.Value);
            //AudioManager.VolumeController.Level[type] = (int)slider.Value;
            //xamarin form only ,tizen.multimedia does not support

            Label sliderLabel = controllerLabelDictionary[type];
            sliderLabel.Text = slider.Value.ToString();
          //  Tizen.Log.Info("volume-app", "drag changed label for " + type + " to " + slider.Value);
        }

        private void UpdateControllerFromEvent(AudioVolumeType type, uint level)
        {
            Slider slider = controllerSliderDictionary[type];
            slider.Value = level;

            Label sliderLabel = controllerLabelDictionary[type];
            sliderLabel.Text = level.ToString();
          //  Tizen.Log.Info("volume-app", "event changed controller for " + type + " to " + level);
        }
    }
}
