 //Capability testing & Getting default sensor
 var pressureCapability = tizen.systeminfo.getCapability("http://tizen.org/feature/sensor.barometer");
 
 if (pressureCapability === true) {
	var pressureSensor = tizen.sensorservice.getDefaultSensor("PRESSURE"); 
   }

 
 var ultravioletCapability = tizen.systeminfo.getCapability("http://tizen.org/feature/sensor.ultraviolet");

 if (ultravioletCapability === true) {
	 var ultravioletSensor = tizen.sensorservice.getDefaultSensor("ULTRAVIOLET");
  }
 
 //Pressure Sensor Callbacks

 function PRSonGetSuccessCB(sensorData) {
	 
	 var infoPRS=document.getElementById('info-prs-div'); 
	 infoPRS.innerHTML="\nPressure Level: " + sensorData.pressure.toFixed(5) + "  hPa";
 }

 function PRSonerrorCB(error) {
	 
     console.log("error occurs");
 }

 function PRSonsuccessCB() {
	 
     console.log("sensor start/changed");
     pressureSensor.getPressureSensorData(PRSonGetSuccessCB, PRSonerrorCB);    
 }
 
 ////
 
 
//To get Pressure sensor data
 function PRS(){ 
	 
	 if (pressureCapability === true) {
	     console.log("Pressure sensor is supported on this device.");
	
	     pressureSensor.setChangeListener(PRSonsuccessCB);
	     pressureSensor.start(PRSonsuccessCB, PRSonerrorCB);
	 }
	     
	 else {
	         
   		console.log("Pressure sensor is not supported on this device.");
   		}
	    	 	 
 }
 
 
//UV Sensor Callbacks
 function UVonGetSuccessCB(sensorData) {
	 
	 var infoUV=document.getElementById('info-uv-div'); 
	 infoUV.innerHTML="\nUV Level : " + sensorData.ultravioletLevel.toFixed(5) + "  Index";
	 
 }

 function UVonerrorCB(error) {
	 
     console.log("error occurs");
 }

 function UVonsuccessCB() {
	 
     console.log("ultraviolet sensor start/changed");
     ultravioletSensor.getUltravioletSensorData(UVonGetSuccessCB, UVonerrorCB);
 }
 
 ////
 
//To get UV sensor data
 function UV(){ 
	 
	 if (ultravioletCapability === true) {
		 
		 console.log("UV sensor is supported on this device.");
		 ultravioletSensor.setChangeListener(UVonsuccessCB);
		 ultravioletSensor.start(UVonsuccessCB,UVonerrorCB);
	 }
	 
	 else {
	     console.log("UV sensor is not supported on this device.");
	 }
 }

 //To stop(disable) sensors
 function stopSens(){ 
	 
	 pressureSensor.stop();
	 ultravioletSensor.stop();
 }
 
 
//To clear screen data
 function clearSCR(){ 
	 
	 var infoPRS=document.getElementById('info-prs-div'); 
	 infoPRS.innerHTML="";
	 
	 var infoUV=document.getElementById('info-uv-div'); 
	 infoUV.innerHTML="";
 }
 
 
 