#include "storage_wrapper.h"

bool
file_exist(void)
{
	struct stat   buffer;
	return (stat (get_file_path(), &buffer) == 0);
}

static bool _storage_cb(int storage_id, storage_type_e type, storage_state_e state, const char *path, void *user_data)
{
   if (type == STORAGE_TYPE_INTERNAL)
   {
      internal_storage_id = storage_id;
      return false;
   }
   return true;
}

void get_external_storage(void)
{
	int error = storage_foreach_device_supported(_storage_cb, NULL);
	if(error != STORAGE_ERROR_NONE)
	{
		LOGI("FILED TO GET INTERNAL STORAGE");
	}
}

bool set_file_path(void)
{
	int error;
	char *path;

	error = storage_get_directory(internal_storage_id, STORAGE_DIRECTORY_SOUNDS, &path);
	if(error != STORAGE_ERROR_NONE){
		return false;
	}

	snprintf(file_path, sizeof(file_path), "%s/"FILE_NAME, path);
	LOGI("%s", get_file_path());
	free(path);
	return true;
}

char * get_file_path(void)
{
	return file_path;
}

void open_file(void)
{
	fp_w = fopen(get_file_path(), "w+");
}

void add_to_file(unsigned char *mp3buffer, short size)
{
	if (fp_w)
	{
		fwrite(mp3buffer, sizeof(char), size, fp_w);
	}
}
