#include "lame_wrapper.h"

lame_global_flags *gfp = NULL;

int
init_encoder(int samplePerSecond, int channels, int bitrate, int quality){
	gfp = lame_init();
	if(gfp){
		lame_set_in_samplerate(gfp, samplePerSecond);
		lame_set_num_channels(gfp, channels);
		lame_set_num_samples(gfp, NUM_SAMPLES);
		lame_set_brate(gfp, bitrate);
		lame_set_mode(gfp,0);
		lame_set_quality(gfp, quality);
		lame_set_VBR(gfp, vbr_off);

		if(lame_init_params(gfp) < 0)
		{
			LOGE("FAILED TO INITIALIZE LAME!!");
			return 0;
		}
		return 1;
	}
	return 0;
}

short
encode_stream(void *pcm_buffer, unsigned char *mp3_buffer, size_t nbytes)
{
	return lame_encode_buffer_interleaved( gfp, pcm_buffer, nbytes, mp3_buffer, W_MAX_BUFF_SIZE );
}

short
encode_flush(unsigned char *mp3buffer)
{
	return lame_encode_flush(gfp, mp3buffer, W_MAX_BUFF_SIZE);
}
