#include "audio_IO.h"

bool
init_audio_IO(void)
{
	audio_io_error_e ret;

	/* initialize audio input */
	ret = audio_in_create(SAMPLE_RATE, AUDIO_CHANNEL_STEREO, AUDIO_SAMPLE_TYPE_S16_LE, &input);
	if(ret != AUDIO_IO_ERROR_NONE)
	{
		LOGE("Filed to initialize audio input");
		return false;
	}

	// setup the filepath
	if(!set_file_path())
	{
		LOGE("Filed to set file path");
		return false;
	}

	// open file
	open_file();

	// register callback
	if(audio_in_set_stream_cb(input, _audio_io_stream_read_cb, NULL)!= AUDIO_IO_ERROR_NONE)
	{
		LOGE("Filed to register callback");
		return false;
	}

	if(audio_in_prepare(input) != AUDIO_IO_ERROR_NONE)
	{
		LOGE("Filed to prepare audio input");
		audio_in_destroy(input);
		return false;
	}

	return true;
}

int
close_audio_IO(){
	if(audio_in_unprepare(input) != AUDIO_IO_ERROR_NONE)
	{
		return 0;
	}

	if(audio_in_destroy(input) != AUDIO_IO_ERROR_NONE)
	{
		return 0;
	}
	return 1;
}

static void
allocate_buffers()
{
	   if(buffer == NULL)
	   {
		   buffer = malloc(W_MAX_BUFF_SIZE);
	   }

	   if(mp3buffer == NULL)
	   {
		   mp3buffer = malloc(W_MAX_BUFF_SIZE);
	   }
}

void
free_buffers()
{
	if(buffer != NULL)
	{
		free(buffer);
	}

	if(mp3buffer != NULL)
	{
		free(mp3buffer);
	}
}

void
flush_mp3_buffer()
{
	short size = encode_flush(mp3buffer);
	add_to_file(mp3buffer, size);
}

void
_audio_io_stream_read_cb(audio_in_h handle, size_t nbytes, void *userdata)
{
	if (nbytes > 0)
	{
		allocate_buffers();

		// Retrieve buffer pointer from audio in buffer
		if(audio_in_peek(handle, &buffer, &nbytes) != AUDIO_IO_ERROR_NONE)
		{
			return;
		}

		short size = encode_stream(buffer, mp3buffer, (nbytes/4));
		add_to_file(mp3buffer, size);

		// Remove audio in data from actual stream buffer
		audio_in_drop(handle);
   }
}
