#ifndef __usinglame_H__
#define __usinglame_H__

#include <app.h>
#include <Elementary.h>
#include <system_settings.h>
#include <efl_extension.h>
#include <dlog.h>
#include <tizen.h>
#include <player.h>

#include "storage_wrapper.h"
#include "audio_IO.h"

#ifdef  LOG_TAG
#undef  LOG_TAG
#endif
#define LOG_TAG "lame"

#if !defined(PACKAGE)
#	define PACKAGE "org.tizen.usinglame"
#endif

#define TIMER_REFRESH_FREQUENCY 1.0

static int screen_width;
static int screen_height;

typedef struct appdata {
	Evas_Object *win;
	Evas_Object *conform;
	Evas_Object *filename;
	Evas_Object *time;
	Evas_Object *record_button;
	Evas_Object *stop_button;
	Evas_Object *cancel_button;
	Evas_Object *play_button;
	Evas_Object *progress;
	time_t start_rec_timestamp;
	player_h player;
	bool playing;
	bool recording;
} appdata_s;

typedef enum{PLAY, PAUSE} play_button_state;

Eina_Bool timer_cb(void *);
void _seek_completed_cb(void *);
void _record_button_clicked(void *, Evas *, Evas_Object *, void *);
void _stop_button_clicked(void *, Evas *, Evas_Object *, void *);
void _cancel_button_clicked(void *, Evas *, Evas_Object *, void *);
void _play_button_clicked(void *, Evas *, Evas_Object *, void *);

void stop_recording(appdata_s*);
void play_button_state_set(play_button_state,appdata_s*);
void release_base_player(appdata_s *);
void play_audio_file(appdata_s *);
void set_file_name(appdata_s*);
void set_timer(appdata_s* , int , int);
float get_player_progress(appdata_s*);
void set_player_progress(appdata_s*, float);
void stop_playing(appdata_s*);

#endif /* __usinglame_H__ */
