/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Xamarin.Forms;

namespace UIComponents
{
    /// <summary>
    /// a simple view contains a SearchBar
    /// </summary>
    public class SearchBarView : ContentPage
    {
        Label resultsLabel;
        SearchBar searchBar;

        /// <summary>
        /// The constructor of SearchBarView class
        /// </summary>
        public SearchBarView()
        {
            /// <summary>
            /// Set title of this page.
            /// </summary>
            Title = "SearchBar";

            /// <summary>
            /// A label is to display search result
            /// </summary>
            resultsLabel = new Label
            {
                Text = "Result will appear here.",
                VerticalOptions = LayoutOptions.FillAndExpand,
                FontSize = 20
            };

            /// <summary>
            /// A SearchBar and its event handler
            /// </summary>
            searchBar = new SearchBar
            {
                Placeholder = "Enter search term",
                FontSize = 20,
                SearchCommand = new Command(() => { resultsLabel.Text = "Result: " + searchBar.Text + " is what you asked for."; })
            };

            StackLayout vLayout = new StackLayout()
            {        
                Spacing = 30,
                Children =
                {
                    searchBar,
                    resultsLabel,
                },
            };

            Content = vLayout;
        }
    }
}

