/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Diagnostics;
using Xamarin.Forms;

namespace UIComponents
{
    /// <summary>
    /// The code provide two types of popups: alert and ActionSheet
    /// </summary>
    public class PopupView : ContentPage
    {
        /// <summary>
        /// The constructor of PopupView class
        /// </summary>
        public PopupView()
        {
            /// <summary>
            /// Set title of this page.
            /// </summary>
            Title = "Popup";

            var list = new ListView();
            list.ItemsSource = new List<String>()
            {
                "Alert",
                "ActionSheet"
            };

            /// <summary>
            /// List item event handler
            /// </summary>
            list.ItemTapped += async (sender, e) =>
            {
                if (e.Item.ToString() == "Alert")
                {
                    /// <summary>
                    /// Popup a alert
                    /// </summary>
                    var answer = await DisplayAlert("Question?", "Would you like to play a game", "Yes", "No");
                    Debug.WriteLine("Answer: " + answer);

                    if (answer)
                    {

                    }
                    else
                    {

                    }
                }
                else if (e.Item.ToString() == "ActionSheet")
                {
                    /// <summary>
                    /// Popup a actionSheet
                    /// </summary>
                    var action = await DisplayActionSheet("ActionSheet: Send to?", "Cancel", null, "Email", "Twitter", "Facebook");
                    Debug.WriteLine("Action: " + action);

                    if (action == "Email")
                    {

                    }
                    else if (action == "Twitter")
                    {

                    }
                    else if (action == "Facebook")
                    {

                    }
                    else
                    {

                    }
                }
            };

            Content = list;
        }
    }
}

