/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using System;

namespace UIComponents.Tizen
{
    class Program : global::Xamarin.Forms.Platform.Tizen.FormsApplication
    {
        private App app;

        /// <summary>
        /// Handle when your app created
        /// </summary>
        protected override void OnCreate()
        {
            base.OnCreate();
            app = new App();
            LoadApplication(app);

            MainWindow.StatusBarMode = ElmSharp.StatusBarMode.Transparent;
            MainWindow.RotationChanged += MainWindow_RotationChanged;
        }

        /// <summary>
        /// Handle the rotation change event of MainWindow.
        /// </summary>
        /// <param name="sender">The object which trigger rotation change event</param>
        /// <param name="e">EventArgs of rotation change event</param>
        private void MainWindow_RotationChanged(object sender, EventArgs e)
        {
            app.RefreshScreen();
        }

        static void Main(string[] args)
        {
            var app = new Program();
            global::Xamarin.Forms.Platform.Tizen.Forms.Init(app);
            app.Run(args);
        }
    }
}
