/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Xamarin.Forms;

namespace UIComponents
{
    /// <summary>
    /// a simple view contains a TimePicker, you can change data if you touch it
    /// </summary>
    public class TimeView : ContentPage
    {
        /// <summary>
        /// The constructor of TimeView class
        /// </summary>
        public TimeView() : base()
        {
            /// <summary>
            /// Set title of this page
            /// </summary>
            Title = "TimePicker";

            /// <summary>
            /// Init a TimePicker for TimeView
            /// </summary>
            TimePicker timePicker = new TimePicker()
            {
                Time = new TimeSpan(17, 0, 0)
            };

            /// <summary>
            /// Add a StackLayout to contain all widgets
            /// </summary>
            Content = new StackLayout
            {
                Spacing = 50,
                Children =
                {
                    timePicker
                }
            };
        }
    }
}

