/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Xamarin.Forms;

namespace UIComponents
{
    /// <summary>
    /// a simple view contains a Stepper, you can change the value
    /// </summary>
    public class StepperView : ContentPage
    {
        /// <summary>
        /// The constructor of StepperView class
        /// </summary>
        public StepperView() : base()
        {
            Stepper stepper = new Stepper()
            {
                HorizontalOptions = LayoutOptions.FillAndExpand,
                Maximum = 100.0,
                Minimum = 0.0,
                Value = 0,
            };

            Label label = new Label()
            {
                 FontSize = 30,
                 HeightRequest = 150,
                 HorizontalOptions = LayoutOptions.FillAndExpand,
                 HorizontalTextAlignment = TextAlignment.Center,
            };

            /// <summary>
            /// Bind label with stepper
            /// </summary>
            label.SetBinding(Label.TextProperty, new Binding("Value") { StringFormat = "Stepper value : {0:F2}" });
            label.BindingContext = stepper;

            Button button1 = new Button()
            {
                HorizontalOptions = LayoutOptions.FillAndExpand,
                Text = "increment"
            };

            Button button2 = new Button()
            {
                HorizontalOptions = LayoutOptions.FillAndExpand,
                Text = "decrement"
            };

            /// <summary>
            /// Button event handler, if you click the button, the value of Stepper will increase
            /// </summary>
            button1.Clicked += new EventHandler((s,a) =>
            {
                stepper.Value += 3.0;
            });

            /// <summary>
            /// Button event handler, if you click the button, the value of Stepper will decrease
            /// </summary>
            button2.Clicked += new EventHandler((s,a) =>
            {
                stepper.Value -= 3.0;
            });

            StackLayout vLayout = new StackLayout()
            {
                Spacing = 50,
                Children =
                {
                    stepper,
                    button2,
                    button1,
                    label,
                },
            };

            Title = "Stepper";
            Content = vLayout;
        }
    }
}

