/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Xamarin.Forms;

namespace UIComponents
{
    /// <summary>
    /// a simple view contains a Slider, you can change the value
    /// </summary>
    public class SliderView : ContentPage
    {
        /// <summary>
        /// The constructor of SliderView class
        /// </summary>
        public SliderView()
        {
            /// <summary>
            /// Set title of this page.
            /// </summary>
            Title = "Slider";

            Slider slider1 = new Slider()
            {
                Maximum = 100.0,
                Minimum = 0.0,
                Value = 20,
            };

            Slider slider2 = new Slider()
            {
                Maximum = 100.0,
                Minimum = 0.0,
                Value = 60,
                IsEnabled = false,
            };

            Label label = new Label()
            {
                 FontSize = 20,
                 HeightRequest = 150,
                 HorizontalOptions = LayoutOptions.FillAndExpand,
                 HorizontalTextAlignment = TextAlignment.Center,
            };

            /// <summary>
            /// Bind label with slider1
            /// </summary>
            label.SetBinding(Label.TextProperty, new Binding("Value") { StringFormat = "Slider value : {0:F2}" });
            label.BindingContext = slider1;

            StackLayout vLayout = new StackLayout()
            {
                Spacing = 50,
                Children =
                {
                    slider1,
                    slider2,
                    label,
                },
            };

            Content = vLayout;
        }
    }
}

