/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Diagnostics;
using Xamarin.Forms;

namespace UIComponents
{
    /// <summary>
    /// A test app contains various lists and to demonstrate ListView usage
    /// </summary>
    public class ListV : ContentPage
    {
        /// <summary>
        /// The constructor of ListV class
        /// </summary>
        public ListV()
        {
            var list = new ListView();
            list.ItemsSource = new List<String>()
            {
                "1Text",
                "2Text",
                "Context"
            };

            /// <summary>
            /// List item event handler
            /// </summary>
            list.ItemTapped += async (sender, e) =>
            {
                if (e.Item.ToString() == "1Text")
                {
                    await Navigation.PushAsync(new List1Text());
                }
                else if (e.Item.ToString() == "Context")
                {
                    await Navigation.PushAsync(new ListContext());
                }
                else if (e.Item.ToString() == "2Text")
                {
                    await Navigation.PushAsync(new List2Text1Check());
                }
            };

            Title = "List";
            Content = list;
        }
    }
}
