/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Diagnostics;

using Xamarin.Forms;

namespace UIComponents
{
    /// <summary>
    /// A list that each cell contains two text items, one image and one switcher.
    /// </summary>
    class List2Text1Check : ContentPage
    {
        /// <summary>
        /// Data source class: name, birthday and photo
        /// </summary>
        class Person
        {
            /// <summary>
            /// The constructor of Person class
            /// </summary>
            /// <param name="name">Person name</param>
            /// <param name="birthday">birthday DateTime</param>
            /// <param name="photo">photo name</param>
            public Person(string name, DateTime birthday, string photo)
            {
                this.Name = name;
                this.Birthday = birthday;
                this.Photo = photo;
            }

            public string Name { private set; get; }
            public DateTime Birthday { private set; get; }
            public string Photo { private set; get; }
        };

        public List2Text1Check()
        {
            /// <summary>
            /// Set title of this page.
            /// </summary>
            Title = "2Text";

            /// <summary>
            /// Define data source
            /// </summary>            
            List<Person> people = new List<Person>
            {
                new Person("Abigail", new DateTime(1975, 1, 15), "gallery_default_image_01.jpg"),
                new Person("Bob", new DateTime(1976, 2, 20), "gallery_default_image_01.jpg"),
                new Person("Yvonne", new DateTime(1987, 1, 10), "gallery_default_image_01.jpg"),
                new Person("Zachary", new DateTime(1988, 2, 5), "gallery_default_image_01.jpg"),
                new Person("Wang", new DateTime(1975, 1, 15), "gallery_default_image_01.jpg"),
                new Person("Li", new DateTime(1976, 2, 20), "gallery_default_image_01.jpg"),
                new Person("Zhang", new DateTime(1987, 1, 10), "gallery_default_image_01.jpg"),
                new Person("Chen", new DateTime(1988, 2, 5), "gallery_default_image_01.jpg"),
                new Person("Kevin", new DateTime(1975, 1, 15), "gallery_default_image_01.jpg"),
                new Person("James", new DateTime(1976, 2, 20), "gallery_default_image_01.jpg"),
                new Person("Axlandar", new DateTime(1987, 1, 10), "gallery_default_image_01.jpg"),
                new Person("Kim", new DateTime(1988, 2, 5), "gallery_default_image_01.jpg"),
                new Person("Lee", new DateTime(1975, 1, 15), "gallery_default_image_01.jpg"),
                new Person("Park", new DateTime(1976, 2, 20), "gallery_default_image_01.jpg"),
                new Person("Choi", new DateTime(1987, 1, 10), "gallery_default_image_01.jpg"),
                new Person("Kang", new DateTime(1988, 2, 5), "gallery_default_image_01.jpg")
            };

            /// <summary>
            /// Create ListView: set ItemsSource and define ItemTemplate 
            /// the item cell contains two labels, one image and one switcher
            /// </summary>
            ListView list = new ListView
            {
                ItemsSource = people,
                RowHeight = 150,

                ItemTemplate = new DataTemplate(() =>
                {
                    Label nameLabel = new Label()
                    {
                        FontSize = 20,
                        TextColor = Color.Black,
                    };
                    nameLabel.SetBinding(Label.TextProperty, "Name");

                    Label birthdayLabel = new Label()
                    {
                        FontSize = 15,
                        TextColor = Color.Gray,
                    };
                    birthdayLabel.SetBinding(Label.TextProperty, new Binding("Birthday", BindingMode.OneWay, null, null, "Born {0:d}"));

                    Image image = new Image()
                    {
                        WidthRequest = 150,
                        HeightRequest = 150,
                    };
                    image.SetBinding(Image.SourceProperty, new Binding("Photo", BindingMode.OneWay, null, null, "{0:d}"));

                    Switch switcher = new Switch
                    {
                        HorizontalOptions = LayoutOptions.EndAndExpand,
                        VerticalOptions = LayoutOptions.CenterAndExpand,
                    };

                    return new ViewCell
                    {
                        View = new StackLayout
                        {
                            Padding = new Thickness(10, 5),
                            Orientation = StackOrientation.Horizontal,
                            HorizontalOptions = LayoutOptions.CenterAndExpand,
                            Children =
                            {
                                image,
                                new StackLayout
                                {
                                    VerticalOptions = LayoutOptions.Center,
                                    Spacing = 10,
                                    Children =
                                    {
                                        nameLabel,
                                        birthdayLabel
                                    }
                                },
                                switcher
                            }
                        }
                    };
                })
            };

            Content = list;
        }
    }
}
