/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Xamarin.Forms;

namespace UIComponents
{
    /// <summary>
    /// A simple view to demostrate image usage
    /// </summary>
    public class ImageView : ContentPage
    {
        public ImageView()
        {
            /// <summary>
            /// Set title of this page.
            /// </summary>
            Title = "Image";

            /// <summary>
            /// Init the first Image
            /// </summary>
            Image image1 = new Image
            {
                Source = "gallery_default_image_01.jpg",
                WidthRequest = 240,
                HeightRequest = 240,
            };
            /// <summary>
            /// Init the second Image
            /// </summary>
            Image image2 = new Image
            {
                Source = "gallery_default_image_01.jpg",
                WidthRequest = 120,
                HeightRequest = 120,
            };
            /// <summary>
            /// the content of ImageView
            /// </summary>
            Content = new StackLayout
            {
                Spacing = 30,
                Children =
                {
                    image1,
                    image2,
                },
            };
        }
    }
}

