/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using System;
using System.Collections.Generic;
using Xamarin.Forms;

namespace UIComponents
{
    /// <summary>
    /// A gallery view which contains many photos
    /// </summary>
    public class Gallery1 : ContentPage
    {
        public Gallery1()
        {
            /// <summary>
            /// Set title of this page.
            /// </summary>
            Title = "Gallery 1";

            /// <summary>
            /// A grid has many rows and columns with same sizes
            /// </summary>
            Grid grid = new Grid
            {
                VerticalOptions = LayoutOptions.FillAndExpand,
            };

            /// <summary>
            /// Place a photos for each grid item, and place a text in the below
            /// </summary>
            for (int i = 0; i < 3; i++)
            {
                for (int j = 0; j < 2; j++)
                {
                    grid.Children.Add(new Image
                    {
                        Source = "gallery_default_image_01.jpg",
                    }, j, i);
                }
            }

            /// <summary>
            /// Add grid as the content.
            /// </summary>
            Content = grid;
        }
    }

    /// <summary>
    /// A gallery view which contains many photos, user can scroll down and up, left and right
    /// </summary>
    /// <remarks>
    /// Currently, the test code is not finished. need to update more
    /// </remarks>
    public class Gallery2 : ContentPage
    {
        public Gallery2()
        {
            /// <summary>
            /// Set title of this page.
            /// </summary>
            Title = "Gallery 2";

            /// <summary>
            /// A grid has many rows and columns with same sizes
            /// </summary>
            Grid grid = new Grid
            {
                VerticalOptions = LayoutOptions.FillAndExpand,
                RowDefinitions =
                {
                    new RowDefinition
                    {
                        Height = new GridLength(300, GridUnitType.Absolute)
                    },
                    new RowDefinition
                    {
                        Height = GridLength.Auto
                    },
                    new RowDefinition
                    {
                        Height = new GridLength(300, GridUnitType.Absolute)
                    },
                    new RowDefinition
                    {
                        Height = GridLength.Auto
                    },
                    new RowDefinition
                    {
                        Height = new GridLength(300, GridUnitType.Absolute)
                    },
                    new RowDefinition
                    {
                        Height = GridLength.Auto
                    },
                    new RowDefinition
                    {
                        Height = new GridLength(300, GridUnitType.Absolute)
                    },
                    new RowDefinition
                    {
                        Height = GridLength.Auto
                    },
                    new RowDefinition
                    {
                        Height = new GridLength(300, GridUnitType.Absolute)
                    },
                    new RowDefinition
                    {
                        Height = GridLength.Auto
                    },
                    new RowDefinition
                    {
                        Height = new GridLength(300, GridUnitType.Absolute)
                    },
                    new RowDefinition
                    {
                        Height = GridLength.Auto
                    },
                },
                ColumnDefinitions =
                {
                    new ColumnDefinition
                    {
                        Width = new GridLength(300, GridUnitType.Absolute)
                    },
                    new ColumnDefinition
                    {
                        Width = new GridLength(300, GridUnitType.Absolute)
                    },
                    new ColumnDefinition
                    {
                        Width = new GridLength(300, GridUnitType.Absolute)
                    },
                    new ColumnDefinition
                    {
                        Width = new GridLength(300, GridUnitType.Absolute)
                    },
                    new ColumnDefinition
                    {
                        Width = new GridLength(300, GridUnitType.Absolute)
                    },
                    new ColumnDefinition
                    {
                        Width = new GridLength(300, GridUnitType.Absolute)
                    },
                },
            };

            /// <summary>
            /// Place a photos for each grid item, and place a text in the below
            /// </summary>
            for (int i = 0; i < 6; i++)
            {
                for (int j = 0; j < 6; j++)
                {
                    grid.Children.Add(new Image
                    {
                        Source = "gallery_default_image_01.jpg",
                    }, j, i * 2);

                    grid.Children.Add(new Label
                    {
                        Text = "Photo",
                        TextColor = Color.Yellow,
                        BackgroundColor = Color.Navy,
                        HorizontalTextAlignment = TextAlignment.Center,
                        VerticalTextAlignment = TextAlignment.Center
                    }, j, i * 2 + 1);
                }
            }

            /// <summary>
            /// Add a ScrollView, user can scroll up and down to find the Apps
            /// </summary>
            ScrollView scrollView = new ScrollView
            {
                HeightRequest = 200,
                VerticalOptions = LayoutOptions.FillAndExpand,
                HorizontalOptions = LayoutOptions.FillAndExpand,
                Orientation = ScrollOrientation.Both,
                Content = grid,
            };

            /// <summary>
            /// Add a StackLayout to contain header and ScrollView
            /// </summary>
            this.Content = new StackLayout
            {
                Children =
                {
                    scrollView
                }
            };
        }
    }

    /// <summary>
    /// A grid contains many widgets: boxView, Image, Label etc.
    /// </summary>
    public class BasicGrid : ContentPage
    {
        public BasicGrid()
        {
            /// <summary>
            /// Set title of this page.
            /// </summary>
            Title = "Basic Grid";

            Grid grid = new Grid
            {
                VerticalOptions = LayoutOptions.FillAndExpand,
                RowDefinitions =
                {
                    new RowDefinition { Height = GridLength.Auto },
                    new RowDefinition { Height = GridLength.Auto },
                    new RowDefinition { Height = new GridLength(1, GridUnitType.Star) },
                    new RowDefinition { Height = new GridLength(100, GridUnitType.Absolute) }
                },
                ColumnDefinitions =
                {
                    new ColumnDefinition { Width = GridLength.Auto },
                    new ColumnDefinition { Width = new GridLength(1, GridUnitType.Star) },
                    new ColumnDefinition { Width = new GridLength(100, GridUnitType.Absolute) }
                }
            };

            /// <summary>
            /// This Label spans two columns
            /// </summary>
            grid.Children.Add(new Label
            {
                Text = "Grid",
                HorizontalOptions = LayoutOptions.Center
            }, 0, 3, 0, 1);

            /// <summary>
            /// This Label spans one grid cell
            /// </summary>
            grid.Children.Add(new Label
            {
                Text = "Autosized cell",
                TextColor = Color.White,
                BackgroundColor = Color.Blue
            }, 0, 1);

            /// <summary>
            /// This BoxView spans one grid cell
            /// </summary>
            grid.Children.Add(new BoxView
            {
                Color = Color.Silver,
                HeightRequest = 0
            }, 1, 1);

            /// <summary>
            /// This BoxView spans one grid cell
            /// </summary>
            grid.Children.Add(new BoxView
            {
                Color = Color.Teal
            }, 0, 2);

            /// <summary>
            /// This Image spans one grid cell
            /// </summary>
            grid.Children.Add(new Image
            {
                Source = "gallery_default_image_01.jpg",
            }, 1, 2);

            /// <summary>
            /// This Label spans two rows
            /// </summary>
            grid.Children.Add(new Label
            {
                Text = "Span two rows (or more if you want)",
                TextColor = Color.Yellow,
                BackgroundColor = Color.Navy,
                HorizontalTextAlignment = TextAlignment.Center,
                VerticalTextAlignment = TextAlignment.Center
            }, 2, 3, 1, 3);

            /// <summary>
            /// This Label spans two columns
            /// </summary>
            grid.Children.Add(new Label
            {
                Text = "Span 2 columns",
                TextColor = Color.Blue,
                BackgroundColor = Color.Yellow,
                HorizontalTextAlignment = TextAlignment.Center,
                VerticalTextAlignment = TextAlignment.Center
            }, 0, 2, 3, 4);

            /// <summary>
            /// This Label spans one grid cell
            /// </summary>
            grid.Children.Add(new Label
            {
                Text = "Fixed 100x100",
                TextColor = Color.Aqua,
                BackgroundColor = Color.Red,
                HorizontalTextAlignment = TextAlignment.Center,
                VerticalTextAlignment = TextAlignment.Center
            }, 2, 3);

            Content = grid;
        }
    }

    /// <summary>
    /// A simple view to demostrate various Grid usages
    /// </summary>
    public class GridV : ContentPage
    {
        public GridV()
        {
            /// <summary>
            /// Set title of this page.
            /// </summary>
            Title = "Grid";

            var list = new ListView();
            list.ItemsSource = new List<String>()
            {
                "Basic",
                "Gallery 1",
                "Gallery 2",
            };

            /// <summary>
            /// List item event handler
            /// </summary>
            list.ItemTapped += async (sender, e) =>
            {
                if (e.Item.ToString() == "Basic")
                {
                    await Navigation.PushAsync(new BasicGrid());
                }
                else if (e.Item.ToString() == "Gallery 1")
                {
                    await Navigation.PushAsync(new Gallery1());
                }
                else if (e.Item.ToString() == "Gallery 2")
                {
                    await Navigation.PushAsync(new Gallery2());
                }
            };

            Content = list;
        }
    }
}
