/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Xamarin.Forms;

namespace UIComponents
{
    /// <summary>
    /// A simple view contains ActivityIndicator to demostrate its usage
    /// </summary>
    public class ActivityIndicatorView : ContentPage
    {
        /// <summary>
        /// A flag to indicate the indicator is running or not
        /// </summary>
        bool isRuning = true;

        public ActivityIndicatorView()
        {
            /// <summary>
            /// Add a label as view title
            /// </summary>
            Title = "ActivityIndicator";

            ActivityIndicator activityIndicator = new ActivityIndicator
            {
                IsRunning = isRuning,
            };

            Button button = new Button
            {
                HorizontalOptions = LayoutOptions.FillAndExpand,
                Text = "Stop",
            };

            /// <summary>
            /// button click event handler, if indicator is running, click it, it will stop
            /// </summary>
            button.Clicked += (sender, e) =>
            {
                if (isRuning)
                {
                    isRuning = false;
                    activityIndicator.IsRunning = isRuning;
                    button.Text = "Start";

                }
                else
                {
                    isRuning = true;
                    activityIndicator.IsRunning = isRuning;
                    button.Text = "Stop";
                }
            };

            this.Content = new StackLayout
            {
                Spacing = 50,
                Children =
                {
                    activityIndicator,
                    button,
                }
            };
        }
    }
}

