/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Xamarin.Forms;

namespace UIComponents
{
    /// <summary>
    /// a view contains TextCell, ImageCell, SwitchCell, ViewCell and demonstrate their usages
    /// </summary>
    public class TableViewV : ContentPage
    {
        /// <summary>
        /// The constructor of TableViewV class
        /// </summary>
        public TableViewV() : base()
        {
            /// <summary>
            /// Set title of this page
            /// </summary>
            Title = "ImageCell";

            /// <summary>
            /// Init a tableView 
            /// </summary>
            TableView tableView = new TableView
            {
                Intent = TableIntent.Form,
                Root = new TableRoot
                {
                    new TableSection("TextCell")
                    {
                        new TextCell
                        {
                            Text = "Choi",
                            Detail = "1980/10/23",
                        },
                        new TextCell
                        {
                            Text = "Park",
                            Detail = "1984/09/12",
                        },
                    },
                    new TableSection("ImageCell")
                    {
                        new ImageCell
                        {
                            ImageSource = ImageSource.FromFile("gallery_default_image_01.jpg"),
                            Text = "Choi",
                            Detail = "1980/10/23",
                        },
                        new ImageCell
                        {
                            ImageSource = ImageSource.FromFile("gallery_default_image_01.jpg"),
                            Text = "Park",
                            Detail = "1984/09/12",
                        },
                    },
                    new TableSection("SwitchCell")
                    {
                        new SwitchCell
                        {
                            Text = "Choi"
                        },
                        new SwitchCell
                        {
                            Text = "Park"
                        },
                    },
                    new TableSection("ViewCell")
                    {
                        new ViewCell
                        {
                            View = new StackLayout
                            {
                                Orientation = StackOrientation.Horizontal,
                                Children =
                                {
                                    new Label
                                    {
                                        Text = "Custom Slider View:",
                                    },
                                    new Slider
                                    {
                                    }
                                }
                            }
                        },
                    },
                }
            };

            /// <summary>
            /// Set table view as the content.
            /// </summary>
            Content = tableView;
        }
    }
}

