/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Xamarin.Forms;

namespace UIComponents
{
    /// <summary>
    /// a simple view contains a Switcher, you can switch on and off
    /// </summary>
    public class SwitchView : ContentPage
    {
        Label label;

        /// <summary>
        /// The constructor of SwitchView class
        /// </summary>
        public SwitchView()
        {
            /// <summary>
            /// Set title of this page.
            /// </summary>
            Title = "Switch";

            Switch switcher = new Switch
            {
                HorizontalOptions = LayoutOptions.Center,
            };
            switcher.Toggled += SwitcherToggled;

            /// <summary>
            /// A label is to display Switcher result
            /// </summary>
            label = new Label()
            {
                Text = "Switch is now False",
                FontSize = 30,
                HeightRequest = 150,
                HorizontalOptions = LayoutOptions.FillAndExpand,
                HorizontalTextAlignment = TextAlignment.Center,
            };

            this.Content = new StackLayout
            {
                Spacing = 50,
                Children =
                {
                    switcher,
                    label
                }
            };
        }

        /// <summary>
        /// Switcher event handler, to display the result
        /// </summary>
        /// <param name="sender"> The object which sends the event.</param>
        /// <param name="e"> The toggle event</param>
        void SwitcherToggled(object sender, ToggledEventArgs e)
        {
            label.Text = String.Format("Switch is now {0}", e.Value);
        }
    }
}

