/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Diagnostics;

using Xamarin.Forms;

namespace UIComponents
{
    /// <summary>
    /// Define ContextActionsCell for list item
    /// </summary>
    public class ContextActionsCell : ViewCell
    {
        /// <summary>
        /// The constructor of ContextActionsCell class
        /// </summary>
        public ContextActionsCell()
        {
            var label1 = new Label 
            {
                Text = "Label 1",
                FontSize = 25,
                FontAttributes = FontAttributes.Bold
            };

            label1.SetBinding(Label.TextProperty, new Binding("."));

            var label2 = new Label
            {
                Text = "Test",
                FontSize = 20
            };

            var moreAction = new MenuItem 
            {
                Text = "More" 
            };

            moreAction.SetBinding(MenuItem.CommandParameterProperty, new Binding("."));
            moreAction.Clicked += (sender, e) =>
            {
                var mi = ((MenuItem)sender);
                Debug.WriteLine("More Context Action clicked: " + mi.CommandParameter);
            };

            var deleteAction = new MenuItem 
            {
                Text = "Delete",
                IsDestructive = true
            };

            deleteAction.SetBinding(MenuItem.CommandParameterProperty, new Binding("."));
            deleteAction.Clicked += (sender, e) =>
            {
                var mi = ((MenuItem)sender);
                Debug.WriteLine("Delete Context Action clicked: " + mi.CommandParameter);
            };

            ContextActions.Add(moreAction);
            ContextActions.Add(deleteAction);

            View = new StackLayout
            {
                Orientation = StackOrientation.Horizontal,
                HorizontalOptions = LayoutOptions.StartAndExpand,
                Padding = new Thickness(15, 5, 5, 15),
                Children =
                {
                    new StackLayout
                    {
                        Orientation = StackOrientation.Vertical,
                        Children = { label1, label2 }
                    }
                }
            };
        }
    }

    /// <summary>
    /// A list that each cell contains a context item
    /// </summary>
    public class ListContext : ContentPage
    {
        /// <summary>
        /// The constructor of ListContext class
        /// </summary>
        public ListContext()
        {
            var list = new ListView();

            list.ItemsSource = new[] { "Wang", "Zhang", "Lee", "Kim" };
            list.ItemTemplate = new DataTemplate(typeof(ContextActionsCell));
            list.RowHeight = 130;

            /// <summary>
            /// List item event handler
            /// </summary>
            list.ItemTapped += async (sender, e) =>
            {
                Debug.WriteLine("Tapped: " + e.Item);
                await DisplayAlert("Tapped", e.Item + " row was tapped", "OK");

                /// <summary>
                /// De-select the row after clicking it
                /// </summary>
                ((ListView)sender).SelectedItem = null;
            };

            Padding = new Thickness(0, 20, 0, 0);
            Content = list;
            Title = "Context";
        }
    }
}
