/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Xamarin.Forms;

namespace UIComponents
{
    /// <summary>
    /// Labels with different font size text
    /// </summary>
    public class FontSizePage : ContentPage
    {
        /// <summary>
        /// The constructor of FontSizePage class
        /// </summary>
        public FontSizePage()
        {
            StackLayout vLayout = new StackLayout
            {
                Children =
                {
                    new Label
                    {
                        Text = "font size set to 15",
                        FontSize = 15,
                        HorizontalOptions = LayoutOptions.CenterAndExpand,
                        HeightRequest = 60,
                    },

                    new Label
                    {
                        Text = "font size set to 25",
                        FontSize = 25,
                        HorizontalOptions = LayoutOptions.CenterAndExpand,
                        HeightRequest = 100,
                    },

                    new Label
                    {
                        Text = "font size set to 35",
                        FontSize = 35,
                        HorizontalOptions = LayoutOptions.CenterAndExpand,
                        HeightRequest = 120,
                    },
                }
            };
            Title = "Font Sizes";
            Content = vLayout;
        }
    }

    /// <summary>
    /// Labels with different text align modes
    /// </summary>
    public class LineBreakModePage : ContentPage
    {
        /// <summary>
        /// The constructor of LineBreakModePage class
        /// </summary>
        public LineBreakModePage()
        {
            StackLayout vLayout = new StackLayout
            {
                Children =
                {
                    new Label
                    {
                        Text = "left aligned label",
                        FontSize = 20,
                        HorizontalTextAlignment = TextAlignment.Start,
                    },

                    new Label
                    {
                        Text = "center aligned label",
                        FontSize = 20,
                        HorizontalTextAlignment = TextAlignment.Center,
                    },

                    new Label
                    {
                        Text = "right aligned label",
                        FontSize = 20,
                        HorizontalTextAlignment = TextAlignment.End,
                    },

                    new Label
                    {
                        Text = "label changes line automatically if label wrap width is set and the text length is bigger than the width of label",
                        FontSize = 20,
                        HorizontalTextAlignment = TextAlignment.Center,
                        LineBreakMode = LineBreakMode.WordWrap,
                    },
                }
            };
            Title = "Linkbreakmodes";
            Content = vLayout;
        }
    }

    /// <summary>
    /// Labels with different text colors
    /// </summary>
    public class TextColorPage : ContentPage
    {
        /// <summary>
        /// The constructor of TextColorPage class
        /// </summary>
        public TextColorPage()
        {
            StackLayout vLayout = new StackLayout
            {
                Children =
                {
                    new Label
                    {
                        Text = "Font color black",
                        TextColor = Color.Black,
                        FontSize = 20,
                        HorizontalOptions = LayoutOptions.CenterAndExpand,
                        HeightRequest = 100,
                    },

                    new Label
                    {
                        Text = "Font color red",
                        TextColor = Color.Red,
                        FontSize = 20,
                        HorizontalOptions = LayoutOptions.CenterAndExpand,
                        HeightRequest = 100,
                    },

                    new Label
                    {
                        Text = "Font color blue",
                        TextColor = Color.Blue,
                        FontSize = 20,
                        HorizontalOptions = LayoutOptions.CenterAndExpand,
                        HeightRequest = 100,
                    },
                }
            };
            Title = "Color Style";
            Content = vLayout;
        }
    }

    /// <summary>
    /// A simple view includes various labels and demonstrate label usages
    /// </summary>
    public class LabelView : ContentPage
    {
        /// <summary>
        /// The constructor of LabelView class
        /// </summary>
        public LabelView()
        {
            var list = new ListView();
            list.ItemsSource = new List<String>()
            {
                "Font Size",
                "Text Color",
                "Line Break Mode",
            };

            /// <summary>
            /// List item event handler
            /// </summary>
            list.ItemTapped += async (sender, e) =>
            {
                if (e.Item.ToString() == "Font Size")
                {
                    await Navigation.PushAsync(new FontSizePage());
                }
                else if (e.Item.ToString() == "Line Break Mode")
                {
                    await Navigation.PushAsync(new LineBreakModePage());
                }
                else if (e.Item.ToString() == "Text Color")
                {
                    await Navigation.PushAsync(new TextColorPage());
                }
            };

            Title = "Label";
            Content = list;
        }
    }
}

