/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Xamarin.Forms;

namespace UIComponents
{
    /// <summary>
    /// CarouselPage consist of three content pages, user can flick one by one
    /// </summary>
    public class CarouselPageView : CarouselPage
    {
        /// <summary>
        /// Init of CarouselPageView class
        /// </summary>
        public CarouselPageView()
        {
            var padding = new Thickness(0, 10, 0, 0);

            /// <summary>
            /// Set title of this page.
            /// </summary>
            Title = "CarouselPage";

            /// <summary>
            /// Init a redContentPage for CarouselPageView class
            /// </summary>
            var redContentPage = new ContentPage
            {
                Padding = padding,
                Content = new StackLayout
                {
                    Children =
                    {
                        new Label
                        {
                            Text = "ContentPage A",
                            FontSize = 20,
                            HeightRequest = 70,
                            HorizontalOptions = LayoutOptions.Center,
                        },
                        new BoxView
                        {
                            Color = Color.Red,
                            HorizontalOptions = LayoutOptions.FillAndExpand,
                            VerticalOptions = LayoutOptions.FillAndExpand,
                        }
                    }
                }
            };

            /// <summary>
            /// Init a greenContentPage for CarouselPageView class
            /// </summary>
            var greenContentPage = new ContentPage
            {
                Padding = padding,
                Content = new StackLayout
                {
                    Children =
                    {
                        new Label
                        {
                            Text = "ContentPage B",
                            FontSize = 20,
                            HeightRequest = 70,
                            HorizontalOptions = LayoutOptions.Center,
                        },
                        new BoxView
                        {
                            Color = Color.Green,
                            HorizontalOptions = LayoutOptions.FillAndExpand,
                            VerticalOptions = LayoutOptions.FillAndExpand,
                        }
                    }
                }
            };

            /// <summary>
            /// Init a blueContentPage for CarouselPageView class
            /// </summary>
            var blueContentPage = new ContentPage
            {
                Padding = padding,
                Content = new StackLayout
                {
                    Children =
                    {
                        new Label
                        {
                            Text = "ContentPage C",
                            FontSize = 20,
                            HeightRequest = 70,
                            HorizontalOptions = LayoutOptions.Center,
                        },
                        new BoxView
                        {
                            Color = Color.Blue,
                            HorizontalOptions = LayoutOptions.FillAndExpand,
                            VerticalOptions = LayoutOptions.FillAndExpand,
                        }
                    }
                }
            };
            /// <summary>
            /// Add the three ContentPage in CarouselPageView class
            /// </summary>
            Children.Add(redContentPage);
            Children.Add(greenContentPage);
            Children.Add(blueContentPage);
        }
    }
}

